/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.FastVector;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSNameImpl;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XPathContext;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLKey;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLSourceContext;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Node;

public class XSLTContext {
    int currentTmpl;
    XSLEventHandler eventHandler;
    Hashtable eventHandlerSet;
    XPathContext currentContext;
    FastVector contexts;
    XPathContext currentContext2;
    FastVector contexts2;
    boolean globalContext = false;
    Hashtable srcSpaceElems;
    Stack srcSpaceStack;
    FastVector varNames;
    FastVector varNamespace;
    FastVector varValues;
    Hashtable globalVariables;
    private Hashtable sourceContext;
    private Hashtable documentTable;
    DOMParser parser;
    XSLStylesheet xsl;
    XMLError err = new XMLError();
    public boolean debugFlag = false;
    XMLNode dbgNode;
    public boolean warning = false;
    OutputStreamWriter out;

    public XSLTContext() {
        this.varNames = new FastVector(16);
        this.varNamespace = new FastVector(16);
        this.varValues = new FastVector(16);
        this.contexts = new FastVector(16);
        this.contexts2 = new FastVector(16);
        this.globalVariables = new Hashtable(20);
        this.eventHandlerSet = new Hashtable(20);
        this.sourceContext = new Hashtable(20);
        this.documentTable = new Hashtable(20);
        this.srcSpaceElems = new Hashtable(20);
        this.srcSpaceStack = new Stack();
    }

    public void addDocument(URL uRL, XMLElement xMLElement) throws XSLException {
        this.documentTable.put(uRL, xMLElement);
    }

    public void addSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        XSLSourceContext xSLSourceContext = new XSLSourceContext(xMLElement, xMLDocument);
        this.sourceContext.put(xMLElement, xSLSourceContext);
    }

    public void error(String string, int n) throws XSLException {
        if (this.debugFlag) {
            this.xsl.error(this.dbgNode, string, n);
        } else {
            this.xsl.error(null, string, n);
        }
    }

    public void error(XMLNode xMLNode, String string, int n) throws XSLException {
        this.xsl.error(xMLNode, string, n);
    }

    public URL getBaseURL() throws XSLException {
        return this.xsl.baseURL;
    }

    public XMLNode getCurrentNode() {
        return this.currentContext.currentNode;
    }

    public XMLNode getCurrentNode2() {
        return this.currentContext2.currentNode;
    }

    public XSLNodeList getCurrentNodeList() {
        return this.currentContext.currentNodeList;
    }

    public int getCurrentTmpl() throws XSLException {
        return this.currentTmpl;
    }

    public boolean getDebugFlag() throws XSLException {
        return this.debugFlag;
    }

    public XMLNode getDebugNode() throws XSLException {
        return this.dbgNode;
    }

    public DecimalFormatSymbols getDecimalFormat(NSNameImpl nSNameImpl) throws XSLException {
        return this.xsl.getDecimalFormat(nSNameImpl);
    }

    public XMLElement getDocument(URL uRL) throws XSLException {
        return (XMLElement)this.documentTable.get(uRL);
    }

    public XMLError getError() {
        return this.err;
    }

    public XSLEventHandler getEventHandler() throws XSLException {
        return this.eventHandler;
    }

    public XSLEventHandler getEventHandler(String string) throws XSLException {
        return (XSLEventHandler)this.eventHandlerSet.get(string);
    }

    public XSLNodeList getKeyNodes(NSName nSName, String string, XMLNode xMLNode) throws XSLException {
        XSLKey xSLKey = this.xsl.getKey(nSName);
        if (xSLKey == null) {
            return null;
        }
        return xSLKey.getMatchingNodes(this, string, xMLNode);
    }

    public XSLSourceContext getSrcContext(XMLNode xMLNode) throws XSLException {
        XMLElement xMLElement = xMLNode.getSrcRoot();
        if (xMLElement == null) {
            return null;
        }
        XSLSourceContext xSLSourceContext = (XSLSourceContext)this.sourceContext.get(xMLElement);
        if (xSLSourceContext != null) {
            return xSLSourceContext;
        }
        XMLDocument xMLDocument = xMLElement.getNodeType() == 9 ? (XMLDocument)xMLElement : (XMLDocument)xMLElement.getOwnerDocument();
        this.addSourceContext(xMLElement, xMLDocument);
        return (XSLSourceContext)this.sourceContext.get(xMLElement);
    }

    public XSLExprValue getVariable(NSName nSName) {
        String string = nSName.getLocalName();
        String string2 = nSName.getNamespace();
        int n = this.varNames.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            if ((String)this.varNames.elementAt(n2) == string && (String)this.varNamespace.elementAt(n2) == string2) {
                return (XSLExprValue)this.varValues.elementAt(n2);
            }
            --n2;
        }
        return (XSLExprValue)this.globalVariables.get(nSName);
    }

    public void init() {
        this.varNames.setSize(0);
        this.varNamespace.setSize(0);
        this.varValues.setSize(0);
        this.contexts.setSize(0);
        this.contexts2.setSize(0);
        this.globalContext = false;
        this.globalVariables.clear();
        this.eventHandlerSet.clear();
        this.sourceContext.clear();
        this.documentTable.clear();
        this.srcSpaceElems.clear();
        this.srcSpaceStack.setSize(0);
    }

    public boolean isSrcWhiteSpaceMode() throws XSLException {
        return false;
    }

    public boolean isSrcWhiteSpacePreserving(String string) throws XSLException {
        if (!this.srcSpaceStack.empty()) {
            return (Boolean)this.srcSpaceStack.peek();
        }
        return this.srcSpaceElems.get(string) != null;
    }

    public void popCurrentNodeList() {
        int n = this.contexts.size();
        this.contexts.setSize(--n);
        this.currentContext = n != 0 ? (XPathContext)this.contexts.elementAt(n - 1) : null;
    }

    public void popCurrentNodeList2() {
        int n = this.contexts2.size();
        this.contexts2.setSize(--n);
        this.currentContext2 = n != 0 ? (XPathContext)this.contexts2.elementAt(n - 1) : null;
    }

    public void popVariable(int n) {
        int n2 = this.varNames.size();
        this.varNames.setSize(n2 -= n);
        this.varNamespace.setSize(n2);
        this.varValues.setSize(n2);
    }

    public void pushCurrentNodeList(XSLNodeList xSLNodeList) {
        XPathContext xPathContext;
        this.currentContext = xPathContext = new XPathContext(xSLNodeList);
        this.contexts.addElement(xPathContext);
    }

    public void pushCurrentNodeList2(XSLNodeList xSLNodeList) {
        XPathContext xPathContext;
        this.currentContext2 = xPathContext = new XPathContext(xSLNodeList);
        this.contexts2.addElement(xPathContext);
    }

    public void pushVariable(NSName nSName, XSLExprValue xSLExprValue) {
        if (this.globalContext) {
            this.globalVariables.put(nSName, xSLExprValue);
            return;
        }
        this.varNames.addElement(nSName.getLocalName());
        this.varNamespace.addElement(nSName.getNamespace());
        this.varValues.addElement(xSLExprValue);
    }

    public void reset() {
        Enumeration enumeration = this.eventHandlerSet.elements();
        while (enumeration.hasMoreElements()) {
            XSLEventHandler xSLEventHandler = (XSLEventHandler)enumeration.nextElement();
            XMLDocumentHandler xMLDocumentHandler = xSLEventHandler.getXMLHandler();
            if (!(xMLDocumentHandler instanceof XSLSAXPrintDriver)) continue;
            try {
                ((XSLSAXPrintDriver)xMLDocumentHandler).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void resetSrcWhiteSpaceMode() throws XSLException {
        if (!this.srcSpaceStack.empty()) {
            this.srcSpaceStack.pop();
        }
    }

    public void setCurrentNode(Node node) {
        this.currentContext.currentNode = (XMLNode)node;
    }

    public void setCurrentNode2(Node node) {
        this.currentContext2.currentNode = (XMLNode)node;
    }

    public void setCurrentTmpl(int n) throws XSLException {
        this.currentTmpl = n;
    }

    public void setDebugFlag(boolean bl) throws XSLException {
        this.debugFlag = bl;
    }

    public void setDebugNode(XMLNode xMLNode) throws XSLException {
        this.dbgNode = xMLNode;
    }

    public void setErrorStream(OutputStreamWriter outputStreamWriter) {
        this.out = outputStreamWriter;
    }

    public void setEventHandler(XSLEventHandler xSLEventHandler) throws XSLException {
        this.eventHandler = xSLEventHandler;
    }

    public void setEventHandler(XSLEventHandler xSLEventHandler, String string) throws XSLException {
        this.eventHandlerSet.put(string, xSLEventHandler);
    }

    public void setGlobalContext(boolean bl) {
        this.globalContext = bl;
    }

    public void setLocale(Locale locale) {
        this.err.setLocale(locale);
    }

    public void setParser(DOMParser dOMParser) throws XSLException {
        this.parser = dOMParser;
    }

    public void setSrcSpaceElems(Hashtable hashtable) {
        this.srcSpaceElems = hashtable;
    }

    public void setSrcWhiteSpaceMode(boolean bl) throws XSLException {
        this.srcSpaceStack.push(new Boolean(bl));
    }

    public void setStyleSheet(XSLStylesheet xSLStylesheet) throws XSLException {
        this.xsl = xSLStylesheet;
    }

    public void showWarnings(boolean bl) {
        this.warning = bl;
    }

    public void warning(String string, int n) throws XSLException {
        this.warning(this.dbgNode, string, n);
    }

    public void warning(XMLNode xMLNode, String string, int n) throws XSLException {
        block7: {
            if (!this.warning) break block7;
            try {
                if (this.debugFlag && xMLNode != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = xMLNode.getSystemId();
                    int n2 = xMLNode.getLineNumber();
                    int n3 = xMLNode.getColumnNumber();
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                    if (n2 != 0 && n3 != 0) {
                        stringBuffer.append("<Line " + n2 + ", Column " + n3 + ">");
                        stringBuffer.append(": ");
                    } else if (string2 != null) {
                        stringBuffer.append(": ");
                    }
                    this.out.write(stringBuffer.toString());
                }
                this.out.write(String.valueOf(this.err.idToString(n)) + ": (" + this.err.typeToString(2) + ") " + string);
                this.out.write(System.getProperty("line.separator"));
                this.out.flush();
            }
            catch (Exception exception) {
                this.error(this.err.getMessage1(1003, exception.getMessage()), 1003);
            }
        }
    }
}

