/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.StringTokenizer;
import oracle.xml.parser.v2.WildCard;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;

class XSLSpaceElem
extends XSLNode
implements XSLConstants {
    private boolean preserve;
    private WildCard[] wildCards;
    private int importPriority;

    XSLSpaceElem(XMLElement xMLElement, XSLStylesheet xSLStylesheet, int n) throws XSLException {
        super(xMLElement, xSLStylesheet);
        this.importPriority = n;
        this.preserve = this.getLocalName() == "preserve-space";
        String string = this.getAttribute("elements");
        this.wildCards = XSLSpaceElem.getWildCards(string);
    }

    int getImportPriority() {
        return this.importPriority;
    }

    private static WildCard[] getWildCards(String string) throws XSLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        WildCard[] wildCardArray = new WildCard[n];
        int n2 = 0;
        while (n2 < n) {
            wildCardArray[n2] = new WildCard(stringTokenizer.nextToken());
            ++n2;
        }
        return wildCardArray;
    }

    WildCard matchWildCard(XMLElement xMLElement, float f) {
        int n = this.wildCards.length;
        int n2 = 0;
        while (n2 < n) {
            WildCard wildCard = this.wildCards[n2];
            if (wildCard.match(xMLElement, this, f)) {
                return wildCard;
            }
            ++n2;
        }
        return null;
    }

    boolean strip() {
        return this.preserve ^ true;
    }
}

