/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import oracle.xml.parser.v2.FastVector;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLPatternInt;
import oracle.xml.parser.v2.XSLSourceContext;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.Node;

class XSLNumber
extends XSLNode
implements XSLConstants {
    private static final String LEVEL_SINGLE = "single";
    private static final String LEVEL_MULTIPLE = "multiple";
    private static final String LEVEL_ANY = "any";
    String p_Value = null;
    String p_Count = null;
    String p_From = null;
    String p_Level = "single";
    String f_Lang = null;
    String f_Format = null;
    String f_LetterValue = null;
    String f_GroupingSeperator = null;
    String f_GroupingSize = null;
    String a_Format = null;
    String a_LetterValue = null;
    String a_GroupingSeperator = null;
    String a_GroupingSize = null;
    DecimalFormat dec_formatter;
    XSLExprInt stringValue = null;
    XSLPatternInt countPattern = null;
    int countAnchorType = -1;
    String[] countAnchorName = new String[2];
    String countAnchorLocalName = null;
    String countAnchorNamespace = null;
    XSLPatternInt fromPattern = null;
    int fromAnchorType = -1;
    String[] fromAnchorName = new String[2];
    String fromAnchorLocalName = null;
    String fromAnchorNamespace = null;
    private static final Integer DEC_FORMAT = new Integer(1);
    private static final Integer ALU_FORMAT = new Integer(2);
    private static final Integer ALL_FORMAT = new Integer(3);
    private static final Integer RMU_FORMAT = new Integer(4);
    private static final Integer RML_FORMAT = new Integer(5);
    FastVector f_Separators;
    FastVector f_Formats;
    String f_Prefix = "";

    XSLNumber(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet, true);
        this.elementType = 1;
    }

    private static String format_Alpha(int n) throws XSLException {
        char[] cArray = new char[256];
        int n2 = cArray.length - 1;
        while (n > 26) {
            int n3 = n % 26;
            n /= 26;
            if (n3 == 0) {
                n3 = 26;
                --n;
            }
            cArray[n2--] = (char)(65 + n3 - 1);
        }
        if (n < 1) {
            return "";
        }
        cArray[n2--] = (char)(65 + n - 1);
        return new String(cArray, n2 + 1, cArray.length - n2 - 1);
    }

    private static String format_Roman(int n) throws XSLException {
        char[] cArray = new char[256];
        int n2 = 0;
        while (n > 0) {
            if (n >= 5000) {
                n -= 5000;
                cArray[n2++] = 80;
                continue;
            }
            if (n >= 1000) {
                if (n >= 4000) {
                    n -= 4000;
                    cArray[n2++] = 77;
                    cArray[n2++] = 80;
                    continue;
                }
                n -= 1000;
                cArray[n2++] = 77;
                continue;
            }
            if (n >= 500) {
                if (n >= 900) {
                    n -= 900;
                    cArray[n2++] = 67;
                    cArray[n2++] = 77;
                    continue;
                }
                n -= 500;
                cArray[n2++] = 68;
                continue;
            }
            if (n >= 100) {
                if (n >= 400) {
                    n -= 400;
                    cArray[n2++] = 67;
                    cArray[n2++] = 68;
                    continue;
                }
                n -= 100;
                cArray[n2++] = 67;
                continue;
            }
            if (n >= 50) {
                if (n >= 90) {
                    n -= 90;
                    cArray[n2++] = 88;
                    cArray[n2++] = 67;
                    continue;
                }
                n -= 50;
                cArray[n2++] = 76;
                continue;
            }
            if (n >= 10) {
                if (n >= 40) {
                    n -= 40;
                    cArray[n2++] = 88;
                    cArray[n2++] = 76;
                    continue;
                }
                n -= 10;
                cArray[n2++] = 88;
                continue;
            }
            if (n >= 5) {
                if (n >= 9) {
                    n -= 9;
                    cArray[n2++] = 73;
                    cArray[n2++] = 88;
                    continue;
                }
                n -= 5;
                cArray[n2++] = 86;
                continue;
            }
            if (n < 1) continue;
            if (n >= 4) {
                n -= 4;
                cArray[n2++] = 73;
                cArray[n2++] = 86;
                continue;
            }
            --n;
            cArray[n2++] = 73;
        }
        return new String(cArray, 0, n2);
    }

    private int getAnyCnt(XSLTContext xSLTContext) throws XSLException {
        XMLNode xMLNode = xSLTContext.getCurrentNode();
        XSLSourceContext xSLSourceContext = xSLTContext.getSrcContext(xMLNode);
        XSLNodeList xSLNodeList = xSLSourceContext.getDocumentOrderList();
        int n = xMLNode.docOrderId - ((XMLNode)xSLNodeList.item((int)0)).docOrderId;
        int n2 = 0;
        while (n >= 0) {
            xMLNode = xSLNodeList.trustedItem(n);
            if (this.fromPattern != null && this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) != null) break;
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) != null) {
                ++n2;
            }
            --n;
        }
        return n2;
    }

    private String getCountString(int[] nArray) throws XSLException {
        String string = "";
        Integer n = DEC_FORMAT;
        String string2 = ".";
        String string3 = ".";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.f_Formats.size();
        int n6 = this.f_Separators.size();
        String string4 = "";
        String string5 = "";
        int n7 = 0;
        int n8 = 0;
        int n9 = nArray.length;
        String string6 = "";
        string = String.valueOf(string) + this.f_Prefix;
        if (n6 > 0) {
            string6 = (String)this.f_Separators.elementAt(--n6);
        }
        while (n2 < n9) {
            Integer n10;
            if (n7 < n5) {
                n = n10 = (Integer)this.f_Formats.elementAt(n7++);
            } else {
                n10 = n;
            }
            if (n10.equals(DEC_FORMAT)) {
                string4 = this.dec_formatter.format(0L);
                string5 = this.dec_formatter.format(nArray[n2]);
                if (n7 < n5) {
                    n4 = n3 = (Integer)this.f_Formats.elementAt(n7++) - string5.length();
                } else {
                    n3 = n4;
                }
                int n11 = 0;
                while (n11 < n3) {
                    string = String.valueOf(string) + string4;
                    ++n11;
                }
                string = String.valueOf(string) + string5;
            } else if (n10.equals(ALU_FORMAT)) {
                string = String.valueOf(string) + XSLNumber.format_Alpha(nArray[n2]);
            } else if (n10.equals(ALL_FORMAT)) {
                string = String.valueOf(string) + XSLNumber.format_Alpha(nArray[n2]).toLowerCase();
            } else if (n10.equals(RMU_FORMAT)) {
                string = String.valueOf(string) + XSLNumber.format_Roman(nArray[n2]);
            } else if (n10.equals(RML_FORMAT)) {
                string = String.valueOf(string) + XSLNumber.format_Roman(nArray[n2]).toLowerCase();
            }
            if (n8 < n6 - 1) {
                string2 = string3 = (String)this.f_Separators.elementAt(n8++);
            } else {
                string3 = string2;
            }
            string = String.valueOf(string) + (n2 < n9 - 1 ? string3 : string6);
            ++n2;
        }
        return string;
    }

    private int[] getMultiCnt(XSLTContext xSLTContext) throws XSLException {
        FastVector fastVector = new FastVector();
        Node node = xSLTContext.getCurrentNode();
        while (node != null && node.getNodeType() == 1) {
            if (this.matchCountPattern((XMLNode)node, -1000.0f, xSLTContext) != null) {
                fastVector.addElement(node);
            }
            if (this.fromPattern != null && this.matchFromPattern((XMLNode)node, -1000.0f, xSLTContext) != null) break;
            node = node.getParentNode();
        }
        int[] nArray = new int[fastVector.size()];
        int n = fastVector.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            nArray[n2] = 0;
            node = (Node)fastVector.elementAt(n);
            while (node != null) {
                if (this.matchCountPattern((XMLNode)node, -1000.0f, xSLTContext) != null && node.getNodeType() == 1) {
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                }
                node = node.getPreviousSibling();
            }
            --n;
            ++n2;
        }
        return nArray;
    }

    private int getSingleCnt(XSLTContext xSLTContext) throws XSLException {
        FastVector fastVector = new FastVector();
        Node node = xSLTContext.getCurrentNode();
        int n = 0;
        while (node != null && node.getNodeType() == 1) {
            if (this.fromPattern != null && this.matchFromPattern((XMLNode)node, -1000.0f, xSLTContext) != null || this.matchCountPattern((XMLNode)node, -1000.0f, xSLTContext) != null) break;
            node = node.getParentNode();
        }
        while (node != null) {
            if (this.matchCountPattern((XMLNode)node, -1000.0f, xSLTContext) != null && node.getNodeType() == 1) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    XSLPatternInt matchCountPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException {
        if (this.countAnchorType != -1) {
            XMLAttr xMLAttr;
            XMLElement xMLElement;
            if (this.countAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.countAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? this.countAnchorLocalName != (xMLElement = (XMLElement)xMLNode).getLocalName() || !this.countAnchorNamespace.equals(xMLElement.getNamespace()) : (xMLNode.getNodeType() == 2 ? this.countAnchorLocalName != (xMLAttr = (XMLAttr)xMLNode).getLocalName() || !this.countAnchorNamespace.equals(xMLAttr.getNamespace()) : xMLNode.getNodeName() != this.countAnchorLocalName))) {
                return null;
            }
        }
        return this.countPattern.matchPattern(xMLNode, f, xSLTContext);
    }

    XSLPatternInt matchFromPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException {
        if (this.fromAnchorType != -1) {
            XMLAttr xMLAttr;
            XMLElement xMLElement;
            if (this.fromAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.fromAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? this.fromAnchorLocalName != (xMLElement = (XMLElement)xMLNode).getLocalName() || !this.fromAnchorNamespace.equals(xMLElement.getNamespace()) : (xMLNode.getNodeType() == 2 ? this.fromAnchorLocalName != (xMLAttr = (XMLAttr)xMLNode).getLocalName() || !this.fromAnchorNamespace.equals(xMLAttr.getNamespace()) : xMLNode.getNodeName() != this.fromAnchorLocalName))) {
                return null;
            }
        }
        return this.fromPattern.matchPattern(xMLNode, f, xSLTContext);
    }

    /*
     * Unable to fully structure code
     */
    private void parseFormatString(String var1_1) throws XSLException {
        this.f_Separators = new FastVector();
        this.f_Formats = new FastVector();
        var3_2 = 0;
        var4_3 = 0;
        var5_4 = 0;
        if (var1_1 == null || (var3_2 = var1_1.length()) == 0) {
            this.f_Formats.addElement(XSLNumber.DEC_FORMAT);
            this.f_Formats.addElement(new Integer(1));
            return;
        }
        var2_5 = new char[var3_2];
        var1_1.getChars(0, var3_2, var2_5, 0);
        var5_4 = var4_3;
        if (!Character.isLetterOrDigit(var2_5[var5_4])) {
            while (var5_4 < var3_2 && !Character.isLetterOrDigit(var2_5[var5_4])) {
                ++var5_4;
            }
            this.f_Prefix = new String(var2_5, var4_3, var5_4 - var4_3);
            var4_3 = var5_4;
        }
        if (var4_3 != var3_2) ** GOTO lbl58
        this.f_Formats.addElement(XSLNumber.DEC_FORMAT);
        this.f_Formats.addElement(new Integer(1));
        return;
lbl-1000:
        // 1 sources

        {
            if (Character.isLetterOrDigit(var2_5[var4_3])) {
                if (Character.isDigit(var2_5[var4_3])) {
                    var5_4 = var4_3 + 1;
                    while (var5_4 < var3_2 && Character.isDigit(var2_5[var5_4])) {
                        ++var5_4;
                    }
                    this.f_Formats.addElement(XSLNumber.DEC_FORMAT);
                    this.f_Formats.addElement(new Integer(var5_4 - var4_3));
                    var4_3 = var5_4;
                    continue;
                }
                switch (var2_5[var4_3]) {
                    case 'A': {
                        this.f_Formats.addElement(XSLNumber.ALU_FORMAT);
                        break;
                    }
                    case 'a': {
                        this.f_Formats.addElement(XSLNumber.ALL_FORMAT);
                        break;
                    }
                    case 'i': {
                        this.f_Formats.addElement(XSLNumber.RML_FORMAT);
                        break;
                    }
                    case 'I': {
                        this.f_Formats.addElement(XSLNumber.RMU_FORMAT);
                        break;
                    }
                    default: {
                        this.f_Formats.addElement(XSLNumber.DEC_FORMAT);
                        this.f_Formats.addElement(new Integer(1));
                    }
                }
                ++var4_3;
                continue;
            }
            var5_4 = var4_3 + 1;
            while (var5_4 < var3_2 && !Character.isLetterOrDigit(var2_5[var5_4])) {
                ++var5_4;
            }
            var6_6 = new String(var2_5, var4_3, var5_4 - var4_3);
            this.f_Separators.addElement(var6_6);
            var4_3 = var5_4;
lbl58:
            // 4 sources

            ** while (var4_3 < var3_2)
        }
lbl59:
        // 1 sources

    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        Object object;
        XMLNode xMLNode = null;
        if (xSLTContext.getDebugFlag()) {
            xMLNode = xSLTContext.getDebugNode();
            xSLTContext.setDebugNode(this);
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        XMLNode xMLNode2 = xSLTContext.getCurrentNode();
        if (this.a_Format != "") {
            this.f_Format = XSLExprBase.getAttributeTemplateValue(xSLTContext, this.a_Format, this);
        }
        this.parseFormatString(this.f_Format);
        if (this.a_GroupingSeperator != "") {
            this.f_GroupingSeperator = XSLExprBase.getAttributeTemplateValue(xSLTContext, this.a_GroupingSeperator, this);
            ((NumberFormat)this.dec_formatter).setGroupingUsed(true);
            object = this.dec_formatter.getDecimalFormatSymbols();
            object.setGroupingSeparator(this.f_GroupingSeperator.charAt(0));
            this.dec_formatter.setDecimalFormatSymbols((DecimalFormatSymbols)object);
        }
        if (this.a_GroupingSize != "") {
            this.f_GroupingSize = XSLExprBase.getAttributeTemplateValue(xSLTContext, this.a_GroupingSize, this);
            ((NumberFormat)this.dec_formatter).setGroupingUsed(true);
            this.dec_formatter.setGroupingSize(Integer.parseInt(this.f_GroupingSize));
        }
        if (this.stringValue != null) {
            object = new int[]{(int)Math.rint(this.stringValue.getNumberValue(xSLTContext))};
        } else {
            if (this.p_Count == null) {
                String string = xMLNode2.getNodeName();
                this.countPattern = XSLExprBase.createPattern(string, this);
                this.countAnchorType = this.countPattern.getAnchorType();
                this.countPattern.getAnchorName(this.countAnchorName);
                this.countAnchorNamespace = this.countAnchorName[0];
                this.countAnchorLocalName = this.countAnchorName[1];
            }
            if (this.p_Level.equals(LEVEL_MULTIPLE)) {
                object = this.getMultiCnt(xSLTContext);
            } else if (this.p_Level.equals(LEVEL_ANY)) {
                object = new int[1];
                object[0] = object[0] + this.getAnyCnt(xSLTContext);
            } else {
                object = new int[]{this.getSingleCnt(xSLTContext)};
            }
        }
        String string = this.getCountString((int[])object);
        xSLEventHandler.characters(string, false);
        if (xSLTContext.getDebugFlag()) {
            xSLTContext.setDebugNode(xMLNode);
        }
    }

    void processAttributes(XSLTContext xSLTContext) throws XSLException {
        super.processAttributes(xSLTContext);
        Locale locale = null;
        XMLNode xMLNode = null;
        if (xSLTContext.getDebugFlag()) {
            xMLNode = xSLTContext.getDebugNode();
            xSLTContext.setDebugNode(this);
        }
        this.p_Value = this.getAttribute("value");
        if (!this.p_Value.equals("")) {
            this.stringValue = XSLExprBase.createStringExpr(this.p_Value, this);
        } else {
            this.p_Value = null;
            this.p_Level = this.getAttribute("level");
            if (this.p_Level.equals("")) {
                this.p_Level = LEVEL_SINGLE;
            }
            this.p_Count = this.getAttribute("count");
            if (this.p_Count.equals("")) {
                this.p_Count = null;
            } else {
                this.countPattern = XSLExprBase.createPattern(this.p_Count, this);
                this.countAnchorType = this.countPattern.getAnchorType();
                this.countPattern.getAnchorName(this.countAnchorName);
                this.countAnchorNamespace = this.countAnchorName[0];
                this.countAnchorLocalName = this.countAnchorName[1];
            }
            this.p_From = this.getAttribute("from");
            if (!this.p_From.equals("")) {
                this.fromPattern = XSLExprBase.createPattern(this.p_From, this);
                this.fromAnchorType = this.fromPattern.getAnchorType();
                this.fromPattern.getAnchorName(this.fromAnchorName);
                this.fromAnchorNamespace = this.fromAnchorName[0];
                this.fromAnchorLocalName = this.fromAnchorName[1];
            } else {
                this.p_From = null;
            }
        }
        this.f_Lang = this.getAttribute("lang");
        if (this.f_Lang != "" && this.f_Lang.length() == 5 && this.f_Lang.indexOf(95) == 2) {
            locale = new Locale(this.f_Lang.substring(0, 2).toLowerCase(), this.f_Lang.substring(3).toUpperCase());
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.dec_formatter = (DecimalFormat)NumberFormat.getInstance(locale);
        this.dec_formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        ((NumberFormat)this.dec_formatter).setGroupingUsed(false);
        this.a_Format = this.getAttribute("format");
        this.a_LetterValue = this.getAttribute("letter-value");
        this.a_GroupingSeperator = this.getAttribute("grouping-separator");
        this.a_GroupingSize = this.getAttribute("grouping-size");
        if (xSLTContext.getDebugFlag()) {
            xSLTContext.setDebugNode(xMLNode);
        }
    }
}

