/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.FastVector;
import oracle.xml.parser.v2.NSNameImpl;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLTContext;
import org.xml.sax.SAXException;

public class XSLEventHandler
implements XSLConstants {
    XMLDocumentHandler xmlHandler;
    XSLTContext context;
    XMLError err;
    NSNameImpl elemName;
    NSNameImpl attrName;
    SAXAttrList attrList;
    String strData;
    char[] charData;
    int size;
    int charlen;
    int currentDataType;
    int currentState;
    int previousState;
    FastVector prefixVect;
    FastVector namespaceVect;
    int[] nspStack;
    int nspIndex = 0;
    static final int NONE = 0;
    static final int CHAR_DATA = 1;
    static final int STR_DATA = 2;
    static final int ELEMENT = 1;
    static final int START_ELEMENT = 2;
    static final int ATTRIBUTE = 3;
    static final int PI = 4;
    static final int COMMENT = 5;
    static final int MESSAGE = 6;

    public XSLEventHandler(XMLDocumentHandler xMLDocumentHandler, XSLTContext xSLTContext) throws XSLException {
        this.xmlHandler = xMLDocumentHandler;
        this.context = xSLTContext;
        this.err = xSLTContext.getError();
        this.prefixVect = new FastVector(16);
        this.namespaceVect = new FastVector(16);
        this.nspStack = new int[16];
        try {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).init();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        this.reset();
    }

    void attribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startAttribute(string, string2, string3);
        this.strData = string4;
        this.currentDataType = 2;
        this.endAttribute(string, string2, string3);
    }

    void characters(String string, boolean bl) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            int n = string.length();
            if (n == 0) {
                return;
            }
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(bl);
            }
            try {
                this.xmlHandler.characters(cArray, 0, n);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.strData = string;
                this.currentDataType = 2;
                break;
            }
            case 2: {
                int n = this.strData.length();
                if (this.size < n) {
                    this.size *= 2;
                    this.size = n > this.size ? n : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n, this.charData, 0);
                this.charlen = n;
            }
            case 1: {
                this.currentDataType = 1;
                int n = string.length();
                int n2 = this.charlen + n;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    char[] cArray = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray, 0, this.charlen);
                    this.charData = cArray;
                }
                string.getChars(0, n, this.charData, this.charlen);
                this.charlen += n;
                break;
            }
        }
    }

    void characters(char[] cArray, int n, int n2, boolean bl) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(bl);
            }
            try {
                this.xmlHandler.characters(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.currentDataType = 1;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    this.charData = new char[this.size];
                }
                System.arraycopy(cArray, n, this.charData, 0, n2);
                this.charlen = n2;
                break;
            }
            case 2: {
                int n3 = this.strData.length();
                if (this.size < n3) {
                    this.size *= 2;
                    this.size = n3 > this.size ? n3 : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n3, this.charData, 0);
                this.charlen = n3;
            }
            case 1: {
                this.currentDataType = 1;
                int n4 = this.charlen + n2;
                if (this.size < n4) {
                    this.size *= 2;
                    this.size = n4 > this.size ? n4 : this.size;
                    char[] cArray2 = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray2, 0, this.charlen);
                    this.charData = cArray2;
                }
                System.arraycopy(cArray, n, this.charData, this.charlen, n2);
                this.charlen += n2;
                break;
            }
        }
    }

    boolean checkAttribute() {
        int n = this.attrList.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (this.attrList.name[n2].intern() == this.attrName.name.intern() && this.attrList.namespace[n2].intern() == this.attrName.namespace.intern()) {
                this.attrList.values[n2] = this.getData();
                return false;
            }
            ++n2;
        }
        return true;
    }

    void comment(String string) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startComment();
        this.strData = string;
        this.currentDataType = 2;
        this.endComment();
    }

    void endAttribute(String string, String string2, String string3) throws XSLException {
        if (this.currentState != 3) {
            if (this.currentState == 6) {
                return;
            }
            this.context.error(String.valueOf(this.err.getMessage0(1900)) + this.currentState, 1900);
        }
        this.currentState = 2;
        if (this.checkAttribute()) {
            this.attrList.addAttr(string, string2, this.attrName.qname, this.getData(), true, 0, string3);
        }
        this.currentDataType = 0;
    }

    void endComment() throws XSLException {
        if (this.currentState != 5) {
            if (this.currentState == 6) {
                return;
            }
            this.context.error(String.valueOf(this.err.getMessage0(1900)) + this.currentState, 1900);
        }
        this.currentState = 1;
        String string = this.getData();
        if (string.indexOf("--") == -1 && !string.endsWith("-")) {
            try {
                this.xmlHandler.comment(string);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        } else {
            this.context.error(this.err.getMessage1(1012, string), 1012);
        }
    }

    void endElement(String string, String string2, String string3) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.context.error(String.valueOf(this.err.getMessage0(1900)) + this.currentState, 1900);
            }
        }
        --this.nspIndex;
        this.prefixVect.setSize(this.nspStack[this.nspIndex]);
        this.namespaceVect.setSize(this.nspStack[this.nspIndex]);
        this.currentState = 1;
        this.setNSName(string, string2, string3, this.elemName);
        try {
            this.xmlHandler.endElement(this.elemName);
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void endMessage() throws XSLException {
        XMLNode xMLNode;
        if (this.currentState != 6) {
            this.context.error(String.valueOf(this.err.getMessage0(1900)) + this.currentState, 1900);
        }
        this.currentState = this.previousState;
        String string = this.getData();
        if (this.context.getDebugFlag() && (xMLNode = this.context.getDebugNode()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = xMLNode.getSystemId();
            int n = xMLNode.getLineNumber();
            int n2 = xMLNode.getColumnNumber();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (n != 0 && n2 != 0) {
                stringBuffer.append("<Line " + n + ", Column " + n2 + ">");
                stringBuffer.append(": ");
            } else if (string2 != null) {
                stringBuffer.append(": ");
            }
            System.out.println(stringBuffer.toString());
        }
        System.out.println("Message: " + string);
    }

    void endProcessingInstruction(String string) throws XSLException {
        if (this.currentState != 4) {
            if (this.currentState == 6) {
                return;
            }
            this.context.error(String.valueOf(this.err.getMessage0(1900)) + this.currentState, 1900);
        }
        this.currentState = 1;
        String string2 = this.getData();
        if (string2.indexOf("?>") == -1) {
            try {
                this.xmlHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        } else {
            this.context.error(this.err.getMessage1(1011, string2), 1011);
        }
    }

    void flushEvents() throws XSLException {
    }

    String getData() {
        String string = "";
        string = this.currentDataType == 2 ? this.strData : new String(this.charData, 0, this.charlen);
        this.currentDataType = 0;
        this.charlen = 0;
        return string;
    }

    XMLDocumentHandler getXMLHandler() {
        return this.xmlHandler;
    }

    void growNamespaceStack() {
        int n = this.nspStack.length;
        int[] nArray = new int[n * 2];
        System.arraycopy(this.nspStack, 0, nArray, 0, n);
        this.nspStack = nArray;
    }

    void message(String string) throws XSLException {
        this.startMessage();
        this.strData = string;
        this.currentDataType = 2;
        this.endMessage();
    }

    void namespaceAttr(String string, String string2) throws XSLException {
        int n = this.prefixVect.size();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            if ((String)this.prefixVect.elementAt(n2) == string) {
                bl = true;
                if ((String)this.namespaceVect.elementAt(n2) != string2) break;
                return;
            }
            --n2;
        }
        this.prefixVect.addElement(string);
        this.namespaceVect.addElement(string2);
        if (string == "") {
            if (bl || string2 != "") {
                this.attribute(string, "xmlns", "http://www.w3/org/XML/1998/namespace", string2);
            }
        } else {
            this.attribute("xmlns", string, "http://www.w3/org/XML/1998/namespace", string2);
        }
    }

    void processingInstruction(String string, String string2) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startProcessingInstruction(string);
        this.strData = string2;
        this.currentDataType = 2;
        this.endProcessingInstruction(string);
    }

    void reportStartElement() throws XSLException {
        try {
            this.xmlHandler.startElement(this.elemName, this.attrList);
            this.attrList.reset();
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void reset() {
        this.prefixVect.setSize(0);
        this.namespaceVect.setSize(0);
        this.nspIndex = 0;
        this.currentDataType = 0;
        this.currentState = 1;
        this.elemName = new NSNameImpl("", "", "", "");
        this.attrName = new NSNameImpl("", "", "", "");
        this.attrList = new SAXAttrList(4);
        this.size = 1024;
        this.charData = new char[1024];
        this.charlen = 0;
    }

    void setNSName(String string, String string2, String string3, NSNameImpl nSNameImpl) {
        nSNameImpl.prefix = string;
        nSNameImpl.name = string2;
        nSNameImpl.qname = string == "" ? nSNameImpl.name : String.valueOf(string) + ":" + string2;
        nSNameImpl.namespace = string3;
    }

    void setXMLHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.xmlHandler = xMLDocumentHandler;
    }

    void startAttribute(String string, String string2, String string3) throws XSLException {
        if (this.currentState != 2) {
            if (this.currentState == 6) {
                return;
            }
            this.context.error(this.err.getMessage2(1047, this.stateToString(3), this.stateToString(this.currentState)), 1047);
        }
        this.currentState = 3;
        this.setNSName(string, string2, string3, this.attrName);
    }

    void startComment() throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.context.error(this.err.getMessage2(1047, this.stateToString(5), this.stateToString(this.currentState)), 1047);
            }
        }
        this.currentState = 5;
    }

    void startElement(String string, String string2, String string3) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.context.error(this.err.getMessage2(1047, this.stateToString(1), this.stateToString(this.currentState)), 1047);
            }
        }
        if (this.nspIndex == this.nspStack.length) {
            this.growNamespaceStack();
        }
        this.nspStack[this.nspIndex++] = this.prefixVect.size();
        this.currentState = 2;
        this.setNSName(string, string2, string3, this.elemName);
    }

    void startMessage() throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        }
        this.previousState = this.currentState;
        this.currentState = 6;
    }

    void startProcessingInstruction(String string) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.context.error(this.err.getMessage2(1047, this.stateToString(4), this.stateToString(this.currentState)), 1047);
            }
        }
        this.currentState = 4;
    }

    String stateToString(int n) {
        switch (n) {
            case 1: {
                return "Element";
            }
            case 2: {
                return "Start element";
            }
            case 3: {
                return "Attribute";
            }
            case 4: {
                return "PI";
            }
            case 5: {
                return "Comment";
            }
            case 6: {
                return "Message";
            }
        }
        return "";
    }
}

