/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLErrorMsg;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLError
implements XMLConstants {
    static String eFilename = "oracle.xml.parser.v2.mesg.XMLErrorMesg";
    Locale eLocale;
    ResourceBundle messages;
    int[] line = new int[101];
    int[] col = new int[101];
    int[] type = new int[101];
    int[] errid = new int[101];
    String[] mesg = new String[101];
    Exception[] exp = new Exception[101];
    String[] sysId = new String[101];
    String[] pubId = new String[101];
    int nerrors = 0;
    int firsterr = -1;
    int lasterr = -1;
    boolean warning = false;
    ErrorHandler err;
    OutputStreamWriter out;
    PrintWriter pw;
    char[] errID = new char[]{'X', 'M', 'L', '-', '0', '0', '0', '0'};
    static final int ERRIDLEN = 8;

    void alloc() {
        if (this.eLocale == null || this.messages == null) {
            this.eLocale = new Locale("en", "US");
            this.getMessageBundle();
        }
    }

    public void error(int n, int n2, String string, String string2, String string3, int n3, int n4, boolean bl) throws XMLParseException {
        this.error(n, n2, string, string2, string3, n3, null, n4, bl);
    }

    void error(int n, int n2, String string, String string2, String string3, int n3, Exception exception, int n4, boolean bl) throws XMLParseException {
        this.alloc();
        if (n4 == 2) {
            if (!this.warning) {
                return;
            }
        } else {
            if (this.firsterr == -1) {
                this.firsterr = this.nerrors;
            }
            this.lasterr = this.nerrors;
        }
        this.line[this.nerrors] = n;
        this.col[this.nerrors] = n2;
        this.errid[this.nerrors] = n3;
        this.pubId[this.nerrors] = string;
        this.sysId[this.nerrors] = string2;
        this.mesg[this.nerrors] = string3;
        this.exp[this.nerrors] = exception;
        this.type[this.nerrors] = n4;
        ++this.nerrors;
        if (bl || this.nerrors == 100) {
            this.flushErrors();
        }
    }

    void error(String string, String string2, String string3, int n, int n2, boolean bl) throws XMLParseException {
        this.error(0, 0, string, string2, string3, n, null, n2, bl);
    }

    void error(String string, String string2, String string3, int n, Exception exception, int n2, boolean bl) throws XMLParseException {
        this.error(0, 0, string, string2, string3, n, exception, n2, bl);
    }

    void error(XMLReader xMLReader, String string, int n, int n2, boolean bl) throws XMLParseException {
        this.error(xMLReader.getLineNumber(), xMLReader.getColumnNumber(), xMLReader.getPublicId(), xMLReader.getSystemId(), string, n, null, n2, bl);
    }

    void error(XMLReader xMLReader, String string, int n, Exception exception, int n2, boolean bl) throws XMLParseException {
        this.error(xMLReader.getLineNumber(), xMLReader.getColumnNumber(), xMLReader.getPublicId(), xMLReader.getSystemId(), string, n, exception, n2, bl);
    }

    void flushErrorHandler() throws SAXException {
        int n = 0;
        while (n < this.nerrors) {
            String string = this.formatErrorMesg(n);
            SAXParseException sAXParseException = this.exp[n] == null ? new SAXParseException(string, this.pubId[n], this.sysId[n], this.line[n], this.col[n]) : new SAXParseException(string, this.pubId[n], this.sysId[n], this.line[n], this.col[n], this.exp[n]);
            switch (this.type[n]) {
                case 0: {
                    this.err.fatalError(sAXParseException);
                    break;
                }
                case 1: {
                    this.err.error(sAXParseException);
                    break;
                }
                case 2: {
                    this.err.warning(sAXParseException);
                    break;
                }
            }
            ++n;
        }
    }

    void flushErrorStream() throws SAXException {
        try {
            int n = 0;
            while (n < this.nerrors) {
                this.out.write(System.getProperty("line.separator"));
                this.out.write(this.formatErrorMesg(n));
                ++n;
            }
            this.out.write(System.getProperty("line.separator"));
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(this.getMessage0(194), iOException);
        }
    }

    void flushErrorStreamPW() throws SAXException {
        int n = 0;
        while (n < this.nerrors) {
            this.pw.write(System.getProperty("line.separator"));
            this.pw.write(this.formatErrorMesg(n));
            ++n;
        }
        this.pw.write(System.getProperty("line.separator"));
        this.pw.flush();
    }

    void flushErrors() throws XMLParseException {
        if (this.nerrors == 0) {
            return;
        }
        try {
            if (this.err != null) {
                this.flushErrorHandler();
            } else if (this.out != null) {
                this.flushErrorStream();
            } else if (this.pw != null) {
                this.flushErrorStreamPW();
            }
        }
        catch (SAXException sAXException) {
            if (this.lasterr != -1) {
                throw new XMLParseException(this, this.firsterr, (Exception)sAXException);
            }
            throw new XMLParseException(this, (Exception)sAXException);
        }
        if (this.lasterr != -1) {
            throw new XMLParseException(this, this.firsterr);
        }
    }

    String formatErrorMesg(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sysId[n] != null) {
            stringBuffer.append(this.sysId[n]);
        }
        if (this.line[n] != 0 && this.col[n] != 0) {
            stringBuffer.append("<Line " + this.line[n] + ", Column " + this.col[n] + ">");
            stringBuffer.append(": ");
        } else if (this.sysId[n] != null) {
            stringBuffer.append(": ");
        }
        stringBuffer.append(String.valueOf(this.idToString(this.errid[n])) + ": (" + this.typeToString(this.type[n]) + ") " + this.mesg[n]);
        return stringBuffer.toString();
    }

    public String getMessage0(int n) {
        this.alloc();
        String string = this.idToString(n);
        return this.messages.getString(string);
    }

    public String getMessage1(int n, String string) {
        this.alloc();
        String string2 = this.idToString(n);
        Object[] objectArray = new String[]{string};
        String string3 = MessageFormat.format(this.messages.getString(string2), objectArray);
        return string3;
    }

    public String getMessage2(int n, String string, String string2) {
        this.alloc();
        String string3 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2};
        String string4 = MessageFormat.format(this.messages.getString(string3), objectArray);
        return string4;
    }

    public String getMessage3(int n, String string, String string2, String string3) {
        this.alloc();
        String string4 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3};
        String string5 = MessageFormat.format(this.messages.getString(string4), objectArray);
        return string5;
    }

    public String getMessage4(int n, String string, String string2, String string3, String string4) {
        this.alloc();
        String string5 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3, string4};
        String string6 = MessageFormat.format(this.messages.getString(string5), objectArray);
        return string6;
    }

    public String getMessage5(int n, String string, String string2, String string3, String string4, String string5) {
        this.alloc();
        String string6 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        String string7 = MessageFormat.format(this.messages.getString(string6), objectArray);
        return string7;
    }

    void getMessageBundle() {
        try {
            this.messages = ResourceBundle.getBundle(eFilename, this.eLocale);
        }
        catch (Exception exception) {
            this.messages = new XMLErrorMsg();
        }
    }

    public String idToString(int n) {
        this.errID[0] = 88;
        if (n < 1000) {
            this.errID[1] = 77;
            this.errID[2] = 76;
        } else {
            this.errID[1] = 83;
            this.errID[2] = n < 2000 ? 76 : 68;
        }
        int n2 = 1;
        while (n2 < 5) {
            this.errID[8 - n2] = (char)(n % 10 + 48);
            n /= 10;
            ++n2;
        }
        return new String(this.errID);
    }

    void init() {
        this.nerrors = 0;
        this.firsterr = -1;
        this.lasterr = -1;
    }

    void setBaseFilename(String string) {
        eFilename = string;
        this.getMessageBundle();
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.warning = true;
        this.err = errorHandler;
    }

    void setErrorStream(OutputStream outputStream) throws IOException {
        this.out = new OutputStreamWriter(outputStream);
    }

    void setErrorStream(OutputStream outputStream, String string) throws IOException {
        this.out = new OutputStreamWriter(outputStream, string);
    }

    void setErrorStream(PrintWriter printWriter) throws IOException {
        this.pw = printWriter;
    }

    public void setLocale(Locale locale) {
        this.eLocale = locale;
        this.getMessageBundle();
    }

    void showWarnings(boolean bl) {
        this.warning = bl;
    }

    public String typeToString(int n) {
        switch (n) {
            case 0: {
                return this.getMessage0(1);
            }
            case 1: {
                return this.getMessage0(2);
            }
            case 2: {
                return this.getMessage0(3);
            }
        }
        return "";
    }
}

