/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLElement
extends XMLNode
implements Element,
Serializable,
NSName,
NSResolver {
    public XMLAttrList attrlist;
    public String defNamespace = null;
    public Hashtable nameSpaces = null;
    public boolean seenNS = false;
    public String prefix = "";
    public String name = "";
    public String namespace = "";
    public ElementDecl ed;

    public XMLElement(String string) {
        super(string.intern(), (short)1, false);
        this.name = this.tag;
    }

    public XMLElement(String string, String string2, String string3) {
        super(string, (short)1);
        this.name = string.intern();
        this.prefix = string2.intern();
        this.namespace = string3.intern();
        if (string2 != "") {
            this.tag = String.valueOf(string2) + ":" + string;
            this.tag = this.tag.intern();
        } else {
            this.tag = this.name;
        }
    }

    public XMLElement(String string, String string2, String string3, String string4) {
        super(string3, (short)1);
        this.name = string;
        this.prefix = string2;
        this.tag = string3;
        this.namespace = string4;
    }

    protected XMLElement(String string, short s) {
        super(string, s);
    }

    public XMLElement(String string, boolean bl) {
        super(string.intern(), (short)1, bl);
        this.name = this.tag;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    public boolean checkNamespace(String string, String string2) {
        if (string2 == null) {
            return string.equals("*") || string == this.name;
        }
        return (string.equals("*") || string == this.name) && string2.equals(this.namespace);
    }

    public Node cloneNode(boolean bl) {
        XMLElement xMLElement = (XMLElement)super.cloneNode(bl);
        if (this.attrlist != null) {
            this.attrlist.parent = xMLElement;
            xMLElement.attrlist = this.attrlist.cloneList(bl);
            this.attrlist.parent = this;
        }
        xMLElement.defNamespace = this.defNamespace;
        xMLElement.nameSpaces = this.nameSpaces;
        xMLElement.seenNS = this.seenNS;
        xMLElement.name = this.name;
        xMLElement.prefix = this.prefix;
        xMLElement.namespace = this.namespace;
        xMLElement.ed = this.ed;
        return xMLElement;
    }

    Vector expectedElements(DTD dTD) {
        if (this.ed == null) {
            this.ed = dTD.findElementDecl(this.tag);
            if (this.ed == null) {
                return null;
            }
        }
        return this.ed.expectedElements(this);
    }

    public Hashtable getAllNamespaceAttrs() {
        Hashtable hashtable = null;
        if (this.parent != null && this.parent.type == 1) {
            hashtable = ((XMLElement)this.parent).getAllNamespaceAttrs();
        }
        if (this.nameSpaces != null) {
            if (hashtable == null) {
                hashtable = new Hashtable(20);
            }
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, this.nameSpaces.get(string));
            }
        }
        return hashtable;
    }

    public Hashtable getAllNamespaceAttrs(String string) {
        Hashtable hashtable = null;
        if (this.parent != null && this.parent.type == 1) {
            hashtable = ((XMLElement)this.parent).getAllNamespaceAttrs(string);
        }
        if (this.nameSpaces != null) {
            if (hashtable == null) {
                hashtable = new Hashtable(20);
            }
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.nameSpaces.get(string2);
                if (string3.equals(string)) continue;
                hashtable.put(string2, this.nameSpaces.get(string2));
            }
            if (hashtable.isEmpty()) {
                return null;
            }
        }
        return hashtable;
    }

    public String getAttribute(String string) {
        Attr attr = this.getAttributeNode(string);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public Attr getAttributeNode(String string) {
        return this.attrlist != null ? (Attr)this.attrlist.getNamedItem(string) : null;
    }

    public Attr getAttributeNode(String string, String string2) {
        if (this.attrlist != null) {
            return (Attr)this.attrlist.getNamedItem(string, string2);
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        return this.attrlist;
    }

    public NodeList getChildrenByTagName(String string) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        String string2 = string.intern();
        int n = this.children.getLength();
        boolean bl = string.equals("*");
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.children.item(n2);
            xMLNode.tag = xMLNode.tag.intern();
            if (bl || xMLNode.tag == string2) {
                xMLNodeList.addNode(xMLNode);
            }
            ++n2;
        }
        return xMLNodeList;
    }

    public NodeList getChildrenByTagName(String string, String string2) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        String string3 = string.intern();
        int n = this.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.children.item(n2);
            if (xMLNode instanceof XMLElement) {
                if (((XMLElement)xMLNode).checkNamespace(string3, string2)) {
                    xMLNodeList.addNode(xMLNode);
                }
            } else if (xMLNode.tag == string3) {
                xMLNodeList.addNode(xMLNode);
            }
            ++n2;
        }
        return xMLNodeList;
    }

    public NodeList getElementsByTagName(String string) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        return this.getElementsByTagName(string.intern(), xMLNodeList, this, null);
    }

    public NodeList getElementsByTagName(String string, String string2) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        return this.getElementsByTagName(string.intern(), xMLNodeList, this, string2);
    }

    private NodeList getElementsByTagName(String string, XMLNodeList xMLNodeList, XMLNode xMLNode, String string2) {
        boolean bl = string.equals("*");
        if (xMLNode.type == 1) {
            if (bl) {
                xMLNodeList.addNode(xMLNode);
            } else if (((XMLElement)xMLNode).checkNamespace(string, string2)) {
                xMLNodeList.addNode(xMLNode);
            }
        }
        int n = xMLNode.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode2 = (XMLNode)xMLNode.children.item(n2);
            if (xMLNode2.type == 1) {
                xMLNodeList = (XMLNodeList)this.getElementsByTagName(string, xMLNodeList, xMLNode2, string2);
            }
            ++n2;
        }
        return xMLNodeList;
    }

    public String getExpandedName() {
        String string = this.namespace != null && !this.namespace.equals("") ? String.valueOf(this.namespace) + ":" + this.name : this.name;
        return string;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    String getNamespacePrefix(String string) {
        if (this.nameSpaces != null) {
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!((String)this.nameSpaces.get(string2)).equals(string)) continue;
                return string2;
            }
        }
        if (this.parent != null && this.parent.type == 1) {
            return ((XMLElement)this.parent).getNamespacePrefix(string);
        }
        return "";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        return this.tag;
    }

    public String getTagName() {
        return this.tag;
    }

    public void normalize() {
        int n = this.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.children.item(n2++);
            if (xMLNode.type == 3 && n2 < n) {
                XMLNode xMLNode2 = (XMLNode)this.children.item(n2++);
                while (xMLNode2.type == 3) {
                    ((XMLText)xMLNode).setNodeValue(String.valueOf(xMLNode.getText()) + xMLNode2.getText(), true);
                    this.removeChild(xMLNode2);
                    if (--n2 < --n) {
                        xMLNode2 = (XMLNode)this.children.item(n2++);
                        continue;
                    }
                    return;
                }
                xMLNode = xMLNode2;
            }
            if (xMLNode.type != 1 || !xMLNode.hasChildNodes()) continue;
            ((XMLElement)xMLNode).normalize();
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        boolean bl2 = xMLOutputStream.mixed;
        int n = xMLOutputStream.outstyle;
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<");
        xMLOutputStream.writeChars(this.tag);
        if (this.attrlist != null) {
            this.attrlist.print(xMLOutputStream, bl);
            String string = this.getAttribute("xml:space");
            if (string != null && string.equals("preserve")) {
                xMLOutputStream.outstyle = XMLOutputStream.COMPACT;
            }
        }
        if (this.children != null && this.children.getLength() > 0) {
            xMLOutputStream.writeChars(">");
            if (this.ed != null) {
                if (this.ed.getContentType() == 3 || this.ed.getContentType() == 2) {
                    xMLOutputStream.mixed = true;
                }
            } else {
                int n2 = this.children.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    XMLNode xMLNode = (XMLNode)this.children.item(n3);
                    if (xMLNode.type == 3 || xMLNode.type == 5) {
                        xMLOutputStream.mixed = true;
                        break;
                    }
                    ++n3;
                }
            }
            xMLOutputStream.writeNewLine();
            xMLOutputStream.addIndent(1);
            this.children.print(xMLOutputStream, bl);
            xMLOutputStream.addIndent(-1);
            xMLOutputStream.writeIndent();
            xMLOutputStream.mixed = bl2;
            xMLOutputStream.writeChars("</" + this.tag + ">");
        } else {
            xMLOutputStream.writeChars("/>");
        }
        xMLOutputStream.writeNewLine();
        xMLOutputStream.outstyle = n;
        xMLOutputStream.flush();
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.attrlist != null) {
            this.checkReadOnly();
            this.attrlist.removeNamedItem(string);
        }
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        XMLAttr xMLAttr = (XMLAttr)attr;
        if (this.attrlist != null && this.attrlist.isMember(xMLAttr)) {
            if (!this.attrlist.setAttributeDefault(xMLAttr)) {
                this.attrlist.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.getXMLError());
        }
        xMLAttr.specified = false;
        return xMLAttr;
    }

    public String resolveNamespacePrefix(String string) {
        String string2;
        if (string == "xml") {
            return "http://www.w3/org/XML/1998/namespace";
        }
        if (string == "xmlns") {
            return "xmlns";
        }
        if (this.nameSpaces != null && (string2 = (String)this.nameSpaces.get(string)) != null) {
            return string2;
        }
        if (this.parent != null && this.parent.type == 1) {
            return ((XMLElement)this.parent).resolveNamespacePrefix(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.setAttribute(string, string2, false);
    }

    void setAttribute(String string, String string2, boolean bl) throws DOMException {
        if (!bl) {
            XMLUtil.validateName(string);
            this.checkReadOnly();
        }
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        this.attrlist.put(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        return (Attr)this.attrlist.setNamedItem(attr);
    }

    public boolean validateContent(DTD dTD) {
        if (this.ed == null) {
            this.ed = dTD.findElementDecl(this.tag);
            if (this.ed == null) {
                return true;
            }
        }
        return this.ed.validateContent(this);
    }
}

