/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.xml.parser.v2.XMLByteReader;
import org.xml.sax.SAXException;

public class XMLCharReader
extends XMLByteReader {
    Reader r = null;
    boolean closeReader = false;
    boolean fixedCoords = false;
    XMLByteReader prevReader = null;
    boolean lastCharNewLine = false;

    public XMLCharReader(Reader reader, String string, String string2) throws IOException {
        this.r = reader;
        this.sysId = string;
        this.pubId = string2;
    }

    public XMLCharReader(String string, String string2, String string3) throws IOException {
        super(string.length());
        this.sysId = string2;
        this.pubId = string3;
        string.getChars(0, string.length(), this.currentBuffer, 0);
        this.currentPos = 0;
        this.eofPos = this.endPos = string.length();
        this.fixedCoords = true;
    }

    public void close() throws SAXException {
        try {
            if (this.r != null && this.closeReader) {
                this.r.close();
            }
            if (this.in != null && this.closeInput) {
                this.in.close();
            }
        }
        catch (IOException iOException) {}
    }

    int fillBuffer(int n) throws IOException {
        if (this.fixedCoords) {
            return 0;
        }
        this.endPos = this.currentPos = this.copyPushBack(n);
        int n2 = 0;
        int n3 = this.BUFSIZE - this.endPos;
        int n4 = 0;
        while (n3 > 0 && n2 != -1) {
            char c;
            n2 = this.r.read(this.currentBuffer, this.endPos, n3);
            if (n2 == -1) continue;
            int n5 = this.endPos + n2 - 1;
            n4 = 0;
            if (this.lastCharNewLine) {
                if (this.currentBuffer[this.endPos] == '\n') {
                    ++n4;
                }
                this.lastCharNewLine = false;
            }
            int n6 = this.endPos;
            if (n4 == 0) {
                while (n6 < n5) {
                    c = this.currentBuffer[n6];
                    if (c == '\n' || c == '\r') {
                        this.setLineNumber(n6);
                        if (c == '\r' && this.currentBuffer[n6 + 1] == '\n') {
                            this.currentBuffer[n6] = 10;
                            ++n4;
                            ++n6;
                            break;
                        }
                        this.currentBuffer[n6] = 10;
                    }
                    ++n6;
                }
            }
            while (n6 < n5) {
                c = this.currentBuffer[n6];
                if (c == '\n' || c == '\r') {
                    this.setLineNumber(n6 - n4);
                    if (c == '\r' && this.currentBuffer[n6 + 1] == '\n') {
                        this.currentBuffer[n6 - n4] = 10;
                        ++n4;
                        ++n6;
                    } else {
                        this.currentBuffer[n6 - n4] = 10;
                    }
                } else {
                    this.currentBuffer[n6 - n4] = this.currentBuffer[n6];
                }
                ++n6;
            }
            if (n6 == n5) {
                if (this.currentBuffer[n6] == '\r') {
                    this.lastCharNewLine = true;
                    this.currentBuffer[n6 - n4] = 10;
                } else {
                    this.currentBuffer[n6 - n4] = this.currentBuffer[n6];
                }
            }
            this.endPos += (n2 -= n4);
            n3 -= n2;
        }
        if (n2 == -1) {
            this.setEOF(this.endPos);
        }
        return this.currentPos;
    }

    public int getColumnNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    public int getLineNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getLineNumber();
        }
        return super.getLineNumber();
    }

    public void reset() {
        this.currentPos = 0;
        this.eofPos = this.endPos;
    }

    void setEncoding(String string) throws IOException {
        this.r = new InputStreamReader(this.in, string);
    }

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setPrevReader(XMLByteReader xMLByteReader) {
        this.prevReader = xMLByteReader;
    }
}

