/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class XMLAttr
extends XMLNode
implements Attr,
NSName,
Serializable {
    int[] outputEscArray = new int[8];
    int currentOutputIndex = 0;
    int outputEscArrayLen = 8;
    public boolean specified = false;
    boolean inUse = false;
    public String prefix = "";
    public String name = "";
    public String namespace = "";

    public XMLAttr(String string, String string2) {
        this(string, "", "", string2);
    }

    public XMLAttr(String string, String string2, String string3, String string4) {
        super(string, (short)2);
        this.name = string.intern();
        this.prefix = string2.intern();
        this.namespace = string3.intern();
        if (string2 != "") {
            this.tag = String.valueOf(string2) + ":" + string;
            this.tag = this.tag.intern();
        } else {
            this.tag = this.name;
        }
        this.text = string4;
    }

    public XMLAttr(String string, String string2, String string3, String string4, String string5) {
        super(string3, (short)2);
        this.name = string;
        this.prefix = string2;
        this.namespace = string4;
        this.text = string5;
    }

    public XMLNode addText(String string) {
        this.text = this.text.concat(string);
        return this;
    }

    void checkArray() {
        if (this.currentOutputIndex == this.outputEscArrayLen) {
            int[] nArray = this.outputEscArray;
            this.outputEscArray = new int[this.outputEscArrayLen * 2];
            System.arraycopy(nArray, 0, this.outputEscArray, 0, this.outputEscArrayLen);
            this.outputEscArrayLen *= 2;
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    public boolean checkNamespace(String string, String string2) {
        if (string2 == null) {
            return string.equals("*") || string == this.name;
        }
        return (string.equals("*") || string == this.name) && string2.equals(this.namespace);
    }

    public Node cloneNode(boolean bl) {
        XMLAttr xMLAttr = (XMLAttr)super.cloneNode(bl);
        xMLAttr.specified = this.specified;
        return xMLAttr;
    }

    public String getExpandedName() {
        String string = this.namespace != null && !this.namespace.equals("") ? String.valueOf(this.namespace) + ":" + this.name : this.name;
        return string;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getName() {
        return this.tag;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public XMLElement getOwnerElement() {
        return (XMLElement)this.parent;
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        return this.tag;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public String getValue() {
        if (this.hasChildNodes()) {
            if (this.text != null) {
                return String.valueOf(this.text) + " " + this.getText();
            }
            return this.getText();
        }
        return this.text;
    }

    boolean isDisableOutputEscaping() {
        return this.currentOutputIndex > 0;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        int n;
        if (!this.specified) {
            return;
        }
        int n2 = this.children.getLength();
        xMLOutputStream.writeChars(" ");
        xMLOutputStream.writeChars(this.tag);
        xMLOutputStream.writeChars("=");
        xMLOutputStream.write(34);
        if (this.text != null) {
            n = this.text.length();
            char[] cArray = new char[n];
            this.text.getChars(0, n, cArray, 0);
            int n3 = 0;
            while (n3 < n) {
                if (cArray[n3] == '&') {
                    xMLOutputStream.writeChars("&#38;");
                } else if (cArray[n3] == '<') {
                    xMLOutputStream.writeChars("&#60;");
                } else if (cArray[n3] == '\"') {
                    xMLOutputStream.writeChars("&#34;");
                } else if (cArray[n3] == '\'') {
                    xMLOutputStream.writeChars("&#39;");
                } else {
                    xMLOutputStream.write(cArray[n3]);
                }
                ++n3;
            }
        }
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                ((XMLNode)this.children.item(n)).print(xMLOutputStream, bl);
                ++n;
            }
        }
        xMLOutputStream.write(34);
        xMLOutputStream.flush();
    }

    void setDisableOutputEscaping(int n) {
        this.checkArray();
        this.outputEscArray[this.currentOutputIndex++] = this.text.length() - n;
        this.outputEscArray[this.currentOutputIndex++] = this.text.length();
    }

    public void setNodeValue(String string) throws DOMException {
        this.checkReadOnly();
        this.text = string;
    }

    public void setValue(String string) {
        this.text = string;
    }
}

