<master src="/packages/vocabulary/www/master">
  <property name="title">@page_title@</property>
  <property name="context">@context@</property>
  <property name="subnavbar_link">@subnavbar_link;noquote@</property>

<p><a href="resources">Resources</a>
<p><a href="design">Design Notes</a>

<h2>Release Notes</h2>
<ul>
<li>This is version 0.10.  It's a "technology preview" because the
      package is under active development and not fully tested.  The
      API and data model are reasonably stable but may change.
<li>I use a native UNICODE postgresql database.  I put the line
      <code>encoding system utf-8</code> into
      <code>serverroot/tcl/zz-postload.tcl</code> but I don't know if
      it made any difference.
</ul>
<h2>Feature list</h2>
Implemented features are <strike>overstruck</strike>.  Current priorities are <strong>in bold face</strong>.

<ol style="color:#666666">

<li>when creating a word, make ortho tests in two directions
<li>make the list of tests prettier
</ol>

<ul>
<li>Bugs:
<ol>
<li>Can be given word tests for words without definitions; these are
          impossible to pass
<li>Random testing will not test you on sentence groups
<li>Ordering of test-2 doesn't match test.
<li><strike>word tests don't respect testing locale</strike>
<li><strong>Lots of imported pinyin still has numbers</strong>
<li><strong>lots of imported definitions have curly brackets</strong>
<li><strike>random testing doesn't do anything interesting if you haven't
              added anything to your lists; instead it should just
              grab something, anything.</strike>
<li><strike>your scores should instead be a list of all tests you either have
              results in or have put on your list; ie, merge tests and
                your tests.</strike>
<li><strike>can't delete definitions; get error on edit</strike>
<li><strike>Deleting words fails if definitions are present - should cascade</strike>
</ol>
<li>Store words
<ol>
<li><strike>store words</strike>
<li><strike>store definitions</strike> - support both links and new
                    text as definitions
<li><strike>store phonetic spellings</strike>
<li>store grammar relationships between words (is the plural of, etc)
<li>standard category trees (parts of speech, etc)
<li>Store licensing information for all content (public domain, GPL,
                            user-only) - via category?
<li>Store information about frequency of appearance of words
<li>Some prioritization of words, so that some are shown less
                                frequently when you get them right a lot
<li>stroke order (via picture?)
</ol>
<li>Store Sentences
<ol>
<li><strike>Basic sentence storage</strike>
<li>categorize sentences
<li><strike>store sentences in groups</strike> (maybe category is enough?)
<li>store information about which words are in the sentences
<li><strike>store groups of sentences</strike> and put a useful label
                        on the group
</ol>
<li>Scoring
<ol>
<li>Consistent rules for storing scores - ie, all scores are 0-100, so
                    getting a word right is 100, getting 3 of 5
                    sentences is 60.
<li>When highlighting errors, do forwards and backwards string match
                                        to isolate the problem area.
</ol>
<li>Testing
<ol>
<li><strike>handle skipped questions</strike>
<li>fix detection of empty answer keys in test-2.tcl
<li>handle a test with no q's
<li><strike>Fix bad answers (my answer is correct, edit anwser) for
                                all</strike> for just you
<li>Show last 5 results and allow filtering out of such words in test
<li>add other types of tests:
<ol>
<li>full sentences
<li>reverse direction for words (from local def to foreign word)
<li>phonetic-based
<li>sound-based tests
</ol>
<li>Better determination of what to test - frequency ranking of tests,
                                or lesson-based testing (from categories?)
<li>"you've gotten this right 5 times in a row; only show it rarely in
                                        the future? y/n
<li><strike>Use a t/f field in tests so that they can be taken off the list
without losing test results - mooted</strike>
</ol>
<li>Data
<ol>
<li>input the full IPA and example words in English, other languages
                          (54 IPA characters now included in install)
<li>Input Dania to the live data, including example words
<li><strike>Input the first Chinese words</strike> - first 3000 or 6000
<li><strong>input some words and definitions from a non-english
                                  language</strong>
<li>Input some chinese 2-character words
<li>Input my Danish lessons (copyright issues - need to restrict access)
</ol>
<li>Import/Export capability
<ol>
<li>CSV export of <strike>words</strike>, sentences, phonetic alphabets
<li>Import a CSV file
<li>CSV import of <strike>words</strike>, sentences, phonetic
                alphabets
<li>export to file - ie, handle mime type correctly
<li>find and implement standards.  IMS?  XML?  <strong>Dict</strong>!  Moby.
<li>Import/export of tests?  SCORM?
<li>automatic lookup of external web services
<li>Live outgoing feed, RSS etc
<li>Framework for syncronizing new data
<ol>
<li>automatic matching on words instead of creating new words
<li>confirmation/conflict resolution pages
</ol>
</ol>
<li><strike>Auto-generate examples by looking into phonetic
                  spelling</strike> okay, now do two examples
<li>Store sounds
<ol>
<li>pronunciations of words
<li>pronunciations of sentences
<li>provide simple online editing tools (trim .2 sec from front or
                                                                      back, etc) so that people can improve their own uploaded samples to match the others
<li>audio tests: see a word, upload your pronunciation, grading by 1)
                                                                        grading yourself after hearing your upload sandwiched between native speaker examples 2) asking for someone to grade you. 
<li>round-trip audio test: you are given a text.  You record yourself
                                                                          and upload it.  Someone else transcribes your recording and you can compare that to the original text.
</ol>
<li>Printable test pages (flashcard mode; test mode)
<li>Utilities
<ol>
<li>Show tooltip/link for every foreign word on the page
<li>"another useful thing: a bookmarklet: so that while I'm reading a
chinese page and I run into an unknown word I select it and hit the
bookmarklet and I get both the dictionary entry plus the word gets
added to my list. that way I can be sure that whenever I look up a
word it will also get added to my list"
<li>scan a specified text and determine how many of the words I
already know
</ol>
<li><strike>Store and allow changing current working locale</strike>
<li><strike>Add a wizard for directly adding word+def to word list</strike>
<li>Navigation & Interface
<ol>
<li><strike>Use subnavbar to show locale settings and subglobal
            nav</strike>
<li><strike>write a flow map for the whole thing</strike>
<li>Do the UI improvements from my paper notes
<li><strike>Put "Add another word" link on word-edit</strike>
<li>Consolidate Words, Sentences, Locales into hierarchy, with Locale
                  list, then per-locale page, then sentences & words

<li><strike>prettier formatting for the white pseudo-button</strike>
</ol>
<li>Coding Hygiene & Platform
<ol>
<li><strike>set and retain the working locales</strike>
<li><strike>move everything into procs</strike>

<li>Add UI for controlling sort order
<li><strike>write a data dictionary/diagram</strike>
<li><strike>Merge vocabulary and vocabulary-test</strike>
<li><strike>redo subnav prep as vocab::conn</strike>
<li><strike>implement the flow map in the new subnavbar</strike>
<li><strike>Think hard about data model for tests and sentences: put
                            sentence hint in test, not sentence?
                            YES. should tests have user_ids?  NO.</strike>
<li><strike>Use subnavbar to show locale settings and subglobal
nav</strike>
<li>Put docs into Docbook
<li>use pretty urls
<li>Write test cases for all of API
<li>Paginate all the lists
<li>Eliminate all of the group count views in favor of paginated lists
that show group count in filter blocks
<li>move all data into content repository
<li>Performance Tuning
<ol>
<li>cache the phonetic chart
</ol>
</ol>
</ul>
<h2>Refactoring list</h2>
<ul>
<li>Make all hyperlinks (export_urls) calculate base url with
package_awareness
<li>Enable sort/filter of multiple includes on the same page
<li><strike>Make vocabulary-trainer use the same subnav structure as vocab</strike>
<li>Move locale information into real table (extension of ad_locales,
with phonetic alphabet name)
<li>Implement permissions
<ol>
<li>Set up at least two roles, student and editor
<li>Enforce roles in all procs and in UI
<li><strike>capture a definition during word creation</strike>
<li><strike>Revise front page into link/portlet thingie</strike>


<li><strike>provide word data via API call</strike>
<li><strike>Don't show button in view mode of word-edit</strike>
</ol>

</ul>
