ad_page_contract {
    Add a word and its tests for a user.

    @author Joel Aufrecht
    @cvs-id $Id: word-train-add.tcl,v 1.1.1.1 2004/02/23 23:00:11 joela Exp $
 
    @param id The id of the word to add.
} {
    id:integer
    return_url
}

set user_id [auth::require_login]
vocab::conn

# Put the word on the user's list
db_dml add_word_to_list "
    insert into vocab_word_list 
           (user_id, word_id, date_added, package_id, locale) 
    values (:user_id, :id, current_timestamp, :package_id, :locale_b)
"

# Assign all locale-appropriate tests for this word to the user
db_dml add_word_tests "
    insert 
      into vocab_user_test_map (user_id, test_id, date_added) 
    select :user_id,
           id,
           current_timestamp
      from vocab_test
     where test_subject = :id
       and locale_b = :locale_b
"

ad_returnredirect $return_url
ad_script_abort