ad_page_contract {
    
    Batch word add
   
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: word-list-add-2.tcl,v 1.1.1.1 2004/02/23 23:00:10 joela Exp $
    
} {
    {return_url word-list}
    locale_a:optional
    locale_b:optional
    word_list
}

set page_title "Add a list of words"
set context $page_title
vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set total_new_words [list]

# split up each line
while {[regexp {(.[^\n]+)} $word_list match_fodder row_csv] } {
    # remove each row as it's handled
    set remove_count [string length $row_csv]
    set word_list [string range $word_list [expr $remove_count + 1] end]
    set word_row [string trim [vocab::csv2list -str $row_csv]]
    # make a word
    set word_id [vocab::word::new \
                     -package_id $package_id \
                     -word [lindex $word_row 0] \
                     -locale $locale_a \
                     -user_id $user_id \
                     -ipa_phonetic [lindex $word_row 2] \
                     -local_phonetic [lindex $word_row 3] \
                     -def_locale $locale_b \
                     -def_list [lindex $word_row 1]]
} 

ad_returnredirect $return_url
ad_script_abort