ad_page_contract {
    
    Form for viewing and editing individual words
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: word-edit.tcl,v 1.1.1.1 2004/02/23 23:00:10 joela Exp $
    
} {
    id:integer,optional
    {return_url ""}
}

if { ![exists_and_not_null return_url] } {
    set return_url [export_vars -base "word-edit" {id}]
}

set page_title "Edit a word"
set context [list [list word-list Words]]
vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set button_target_ipa ""
set button_target_locale ""
set locale_a $locale_a

#---------------------------------------------------------------------
# Do special things in case we are reloading a submitted form
#---------------------------------------------------------------------
# catch missing local_phonetic when submitting from a form
# where that field was hidden
if {![exists_and_not_null local_phonetic] } {
    set local_phonetic ""
}
# pre-query for the object's locale, which can override locale_a
# yes, we're querying the database twice for the same thing
# that's still faster than hacking ad_form
if { [exists_and_not_null id]} {
    set locale_a [db_string get_locale "
                            select locale
                              from vocab_word
                             where id = :id
" -default ""]
}
#---------------------------------------------------------------------

set phonetic_alphabet [vocab::phonetic_alphabet_for_locale -locale $locale_a]
set locale_options [vocab::locale_list -all all]
set form_mode [ad_decode [ad_form_new_p -key id] 1 "edit" "display"]
set new_word_url [export_vars -base word-edit]
set form_help ""

ad_form \
    -name word \
    -mode $form_mode \
    -form {

	{id:key}
	{word:text 
	    {label Word}
	}
	{locale:text(select)
	    {label Locale}
	    {options $locale_options}
	}
	{ipa_phonetic:text,optional
	    {label "IPA"}
            {help_text "Phonetic spelling in<br>International Phonetic Alphabet"}
	}
    }

if { ![string equal $phonetic_alphabet none]} {
    ad_form -extend -name word -form {
	{local_phonetic:text,optional
	    {label "[set phonetic_alphabet]"}
            {help_text "Phonetic spelling in [set phonetic_alphabet]"}
	}
    }
}

if { [string equal $form_mode "edit"]} {
    ad_form -extend -name word -form {
	{definition:text,optional
	    {label "Definition in [set label_b]"}
            {help_text "One or more words,<br>separated by commas"}
	}
    }
}

ad_form -extend -name word \
    -new_request {
	set page_title "Add a Word"
	lappend context $page_title
	set button_target_ipa word.ipa_phonetic.value
        
        # this pre-sets the form locale
        set locale $locale_a
	if { [exists_and_not_null phonetic_alphabet]} {
	    set button_target_locale word.local_phonetic.value
        }

        set form_help "<div class=\"form-help-text\">[vocab::img::help] If any definitions are included, tests are automatically created.</div>"

         
    } -edit_request {

	vocab::word::get -id $id -array word_array -locale_b $locale_b
        set word $word_array(word)
        set locale $word_array(locale)
        set ipa_phonetic $word_array(ipa_phonetic)
        set local_phonetic $word_array(local_phonetic)

	set page_title $word
	lappend context $page_title

        # this may be redundant with the prefetch
	set locale_a $locale
	set phonetic_alphabet [vocab::phonetic_alphabet_for_locale -locale $locale_a]

        if { [string equal $form_mode edit] } {
            set button_target_ipa word.ipa_phonetic.value
            if { [exists_and_not_null phonetic_alphabet]} {
                set button_target_locale word.local_phonetic.value
            }
        }

	if {![exists_and_not_null return_url]} {
	#TODO: new_id is the wrong thing to redirect to, probably thanks
        # to cr dumbness, so this breaks
	    set return_url [export_vars -base [ad_conn url] {id}]
	#    set return_url "."
        }

    } -new_data {
        
	set user_id [auth::require_login]
	set new_id [vocab::word::new \
                        -package_id $package_id \
                        -word $word \
                        -locale $locale \
                        -ipa_phonetic $ipa_phonetic \
                        -local_phonetic $local_phonetic \
                        -user_id $user_id \
                        -def_locale $locale_b \
                        -def_list $definition
                   ]

	if {![exists_and_not_null return_url]} {
	#TODO: new_id is the wrong thing to redirect to, probably thanks
        # to cr dumbness, so this breaks
	    set return_url [export_vars -base word-edit {{id $new_id}}]
	#    set return_url "."
        }
        
        ad_returnredirect $return_url
	ad_script_abort
        
    } -edit_data {

	auth::require_login
	vocab::word::edit \
            -id $id \
            -word $word \
            -locale $locale \
            -ipa_phonetic $ipa_phonetic \
            -local_phonetic $local_phonetic

    } -after_submit {

	ad_returnredirect $return_url
	ad_script_abort

    }

