ad_page_contract {
    Framework page for showing a list of questions and collecting answers.  Handles specified tests as well choosing random questions if necessary.
} {
    {size:integer 10}
    {test_type ""}
    {test_id ""}
}

vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set page_title "Test"
set action_url "test-2"
set context $page_title
set repeat_url [export_vars -base [ad_conn url] {size test_type test_id}]
template::list::create \
    -name test \
    -multirow test \
    -elements {
        question {
            label ""
            display_template {
                @test.question;noquote@
            }
        }
        answer {
            label ""
            display_template {
                <input type="hidden" name="test_id.@test.rownum@" value="@test.test_id@">
                <input type="text" name="a.@test.rownum@" size="@test.answer_size@">
            }
        }
    }

# figure out what tests to do
# this is pretty ad_hoc
# probably a better thing is to do the figuring first, and then use a switch
# to do the appropriate retrieval
# or hide it all in a proc
if { [string equal $test_type "sentence_group"] } {
    # if we are told ahead of time that it's a sentence group, then it has its own list of tests
    db_multirow -extend {question answer_size} test test_select "
        select vts.subject_id as test_id
          from vocab_test_subject vts
         where vts.test_id = :test_id
    " {
        vocab::train::test::get -test_id $test_id -array test_array
        set question $test_array(question)
	set answer_size 40
    }
    
} elseif { [exists_and_not_null test_id] } {
    # if a specific id is requested, do it
    db_multirow  -extend {question answer_size} test test_select "
        select vt.id as test_id
          from vocab_test vt
         where vt.id = :test_id
           and vt.package_id = :package_id
           and vt.test_type != 'sentence_group'
    " {
        vocab::train::test::get -test_id $test_id -array test_array -target_locale $locale_b
        set question $test_array(question)
	set answer_size 15
    }


} else {
    # just get ten random tests
    # excluding sentence_group is a kludge
    # if user has no tests, go random.

    set user_has_tests [db_string user_has_tests_select "
                          select count(*)
                            from vocab_user_test_map vutm,
                                 vocab_test vt
                           where vutm.user_id = :user_id
                             and vt.id = vutm.test_id
                             and vt.package_id = :package_id"]

    if { $user_has_tests > 0 } {
        db_multirow  -extend {question answer_size} test test_select "
        select vt.id as test_id,
               random() as random
          from vocab_user_test_map vutm,
               vocab_test vt
         where vutm.user_id = :user_id
           and vt.id = vutm.test_id
           and vt.package_id = :package_id
           and vt.test_type != 'sentence_group'
         order by random
         limit $size
    " {
        vocab::train::test::get -test_id $test_id -array test_array -target_locale $locale_b
        set question $test_array(question)
	set answer_size 10
    }
    } else {
    db_multirow  -extend {question answer_size} test test_select "
        select vt.id as test_id,
               vt.question,
               random() as random
          from vocab_test vt
         where vt.package_id = :package_id
           and vt.test_type != 'sentence_group'
           and vt.locale_b = :locale_b
         order by random
         limit $size
    " {
        vocab::train::test::get -test_id $test_id -array test_array -target_locale $locale_b
        set question $test_array(question)
	set answer_size 10
    } if_no_rows {
        # maybe implement this?  Right now we don't check label_a, because the purpose
        # is to show somebody a test and if we check locale_a and locale_b then, thanks
        # to default locale values, we will usually be showing this message
        set message "There are no tests from $label_a to $label_b.  Try changing your locale."
    }


    }
    
}