ad_page_contract {
    Process incoming test and show results.
} {
    test_id:integer,array
    a:array
    {repeat_url ""}
}

set page_title "Test"
set context $page_title

vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set action_url "test-3"
# kludge here because I can't understand the list stuff
if { [exists_and_not_null repeat_url] } {
    set actions [list "Test more" [export_vars -base test ] "Test More" "Repeat this test" $repeat_url "Repeat this test"]
} else {
    set actions [list "Test more" [export_vars -base test ] "Test More"]
}

template::list::create \
    -name test \
    -multirow test \
    -actions $actions \
    -elements {
        question {
            label "Question"
            display_template {
                @test.question;noquote@
            }
        }
        user_answer {
            label "Your Answer"
            display_template {
                <if @test.score@ eq 0>
                <span style=\"background: pink; padding:0.2em;\">
                @test.user_answer@</span>
                </if>
                <elseif @test.score@ eq 1>
                <span style=\"background: lightgreen; padding:0.2em;\">
                @test.user_answer@</span>
                </elseif>
                <else>
                @test.user_answer@
                </else>
            }
        }
        answer {
            link_url_col answer_url
            label "Acceptable Answers"
        }
        score {
            label "Score"
        }
        override {
            display_template {
            <if @test.score@ eq 0 and @test.test_subject@ not nil>
            <input type="checkbox" name="test_id.@test.rownum@" value="@test.test_id@"> 
            <input type="hidden" name="a.@test.rownum@" value="@test.user_answer@">
            <input type="hidden" name="date.@test.rownum@" value="@test.date@">
            </if>
            }
        }
    }

template::multirow create test test_id test_subject question user_answer answer score date answer_url

set correct_count 0
set total_count 0

# TODO: by getting fancier with the array processing,
# we lost the array ordering.  would be nice to fix that,
# maybe by finding the highest i, then walking up to it,
# assuming a sparse array
set searchId [array startsearch test_id]
for {set j 1} { $j <= [array size test_id] } {incr j} {
    set i [array nextelement test_id $searchId]
    set answer_url [export_vars -base "test-edit" {{id $test_id($i)}}]
    if { [exists_and_not_null test_id($i)] && [exists_and_not_null a($i)] } {
        vocab::train::result::submit \
            -test_id $test_id($i) \
            -user_id $user_id \
            -answer1 $a($i) \
            -target_locale $locale_b \
            -array result
        if { $result(score) } {
            incr correct_count
        }
        incr total_count
        template::multirow append test $test_id($i) $result(test_subject) $result(question) $result(user_answer) $result(correct_answer) $result(score) $result(date) $answer_url
    } else {
        vocab::train::test::get -test_id $test_id($i) -array result -target_locale $locale_b
        template::multirow append test "" "" $result(question) "-" [join $result(answer)] "-" "" $answer_url
    }
}
array donesearch test_id $searchId