ad_page_contract {
    Receive a list of words, and show a form to allow definitions to be added.
} {
    {new_words ""}
    {locale ""}
}

set page_title "Add words from sentences"
set context [list $page_title]
set locale_a $locale

vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set def_locale $locale_b
set locale_options [vocab::locale_list -all all]

set locale_b_html [template::widget::menu locale_b $locale_options $locale_b attribute_reference]
set action_url "sentence-words-2"

if {![exists_and_not_null new_words]} {
    ad_returnredirect "sentence-list"
    abort
}

template::list::create \
    -name words \
    -multirow words \
    -elements {
        word {
            label "Word from sentence"
            display_template {
                <input type="text" name="word.@words.rownum@" value="@words.word@">
            }
        }
        definition {
            label "New Definition"
            display_template {
                <input type="text" name="def.@words.rownum@" size="15">
            }
        }
         old_definition {
             label "Existing Definitions in [set label_b]"
             display_template {
                 @words.old_definition@
             }
         }
    }

template::multirow create words word old_definition

# TODO: Instead of lsearching used_words, it would be more elegant
# to just look in the multirow we're creating but I'm not sure 
# how to do that

set used_words [list]
foreach word  $new_words {
    if { [lsearch $used_words $word] < 0 } {
        template::multirow append words $word [join [vocab::word::def::get_by_word -word $word -locale $def_locale] {, }]
        lappend used_words $word
    }
}

