ad_page_contract {
    
    Batch sentence add
   
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: sentence-group-add-2.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
    
} {
    locale
    sentence_group
}

set page_title "Add a group of Sentences"
set context $page_title
vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

# always create a new test, under the assumption that if sentence_group
# was null, we wouldn't even be here

set test_id [vocab::train::test::new \
                 -package_id $package_id \
                 -test_type "sentence_group" \
                 -locale_a $locale]

# split up each line
set total_new_words [list]
while {[regexp {(.[^\n]+)} $sentence_group match_fodder row] } {
    # remove each row as it's handled
    set remove_count [string length $row]
    set sentence_group [string range $sentence_group [expr $remove_count + 1] end]
    set row [split $row |]
    set sentence [string trim [lindex $row 0]]
    set hint [string trim [lindex $row 1]]

    # make a sentence
    set sentence_id [vocab::sentence::new \
                         -user_id $user_id \
                         -package_id $package_id \
                         -text $sentence \
                         -locale $locale \
                         -word_list new_words]

    append total_new_words $new_words
    append total_new_words " "
    # make a test
    set sentence_test_id [vocab::train::test::new \
                              -package_id $package_id \
                              -test_type "sentence_from_hint" \
                              -test_subject $sentence_id \
                              -locale_a $locale \
                              -question $hint ]

    # put the test in the group
    db_dml link_sentence_to_group "
              insert 
                into vocab_test_subject (test_id, subject_id)
              values (:test_id, :sentence_test_id)"

}    

# now give a chance to add all of these lovely new words
ad_returnredirect [export_vars -base sentence-words { locale {new_words $total_new_words} }]

#ad_returnredirect [export_vars -base sentence-list {{group $test_id}}]
abort