ad_page_contract {
    This is the view-edit page for sentences.

    @author Your Name (you@example.com)
    @cvs-id $Id: sentence-edit.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
} {
    id:integer,optional
}

set page_title "Edit"
set context [list [list sentence-list Sentences]]
vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set locale_options [vocab::locale_list -all all]

ad_form -name sentence -form {
    {id:key}
    {locale:text(select)
        {label Locale}
        {options $locale_options}
    }
    {text:text(textarea)
        {label Sentence}
        {html {cols 50}
            {rows 4}
        }
    }

} -new_request {
    
    set page_title "Add a Sentence"
    lappend context $page_title
    # this pre-sets the form locale
    set locale $locale_a
    
} -edit_request {
    
    vocab::sentence::get \
	-id $id \
	-array sentence_array 
    
    set locale $sentence_array(locale)
    set text $sentence_array(text)
    set page_title "Edit a Sentence"
    lappend context $page_title

} -new_data {
    
    set user_id [auth::require_login]
    set id [vocab::sentence::new \
                -locale $locale \
                -package_id $package_id \
                -user_id $user_id \
                -text $text \
                -word_list new_words]
    set return_url [export_vars -base sentence-words { locale new_words }]
    
} -edit_data {

    auth::require_login
    vocab::sentence::edit \
	-id $id \
	-text $text \
        -locale $locale 
    set return_url [export_vars -base [ad_conn url] {id}]

} -after_submit {

    ad_returnredirect $return_url
    ad_script_abort
}

# this code must lie fallow until 5.1
# category::ad_form::add_widgets \
#     -form_name sentence \
#    -container_object_id [ad_conn package_id] \
#     -categorized_object_id [value_if_exists item_id]

#     category::map_object \
#         -remove_old \
#         -object_id $item_id \
#        $category_ids

#     category::map_object \
#         -remove_old \
#         -object_id $item_id \
#         $category_ids

