ad_page_contract {
    
    Form for editing IPA symbol examples.
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: phonetic-example-edit.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
    
} {
    phonetic_id:integer,optional
    id:integer,optional
} -validate {
    some_id_provided {
        if { ![exists_and_not_null phonetic_id] } {
            if { [exists_and_not_null id] } {
                set phonetic_id [db_string get_phonetic_id "select phonetic_id 
                                                    from vocab_phonetic_example
                                                   where id = :id"]
            } else {
                ad_complain "Neither id nor phonetic_id provided."
            }
        }
    }
}

set page_title ""
set package_id [ad_conn package_id]
vocab::subnav_prep -package_id $package_id

set phonetic_title [db_string phonetic_title_select "select phonetic_symbol from vocab_phonetic where id=:phonetic_id"]

set context [list [list [export_vars -base "phonetic-edit" { {id $phonetic_id} }] $phonetic_title]]

set word_options [db_list_of_lists words {
    select (vw.word || ' (' || (select label 
  		          from ad_locales
                         where locale = vw.locale) || ')'),
           vw.id
      from vocab_word vw
     where vw.package_id = :package_id
    order by word
}]


set form_mode [ad_decode [ad_form_new_p -key id] 1 "edit" "display"]

ad_form \
    -name phonetic_example_edit \
    -mode $form_mode \
    -form {
        {id:key}
        {phonetic_id:integer(hidden)}
        {symbol:text(inform) {value $phonetic_title}}
        {word_id:integer(select)
            {label Word}
            {options $word_options}
        }
        {comments:text,optional}
    } -new_request {
        permission::require_permission -object_id [ad_conn package_id] -privilege create
        set page_title "Add an example"
        lappend context $page_title
    } -edit_request {
        permission::require_write_permission -object_id $package_id
        db_1row phonetic_example_select {
            select word_id,
               comments
          from vocab_phonetic_example
         where id = :id
    }
    set page_title "Edit $phonetic_title"
    lappend context $page_title

} -new_data {

    auth::require_login
    db_dml phonetic_example_insert {
        insert into vocab_phonetic_example
        (phonetic_id, word_id, comments)
        values (:phonetic_id, :word_id, :comments)
    }

} -edit_data {

    auth::require_login
    db_dml phonetic_edit {
        update vocab_phonetic_example
           set word_id = :word_id,
               comments = :comments
        where id = :id
    }

} -after_submit {

    ad_returnredirect [export_vars -base "phonetic-example" { {id $phonetic_id} } ]
    ad_script_abort

}