ad_page_contract {
    
    Form for editing IPA symbols.
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: phonetic-edit.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
    
} {
    id:integer,optional
    {return_url ""}
    {phonetic_locale ""}
}

vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

# decide whether or not to do this when not sleepy:
#set phonetic_locale $locale_b
set phonetic_name [vocab::phonetic_alphabet_for_locale -locale $phonetic_locale]
set page_title "Add a $phonetic_name symbol"
set context $page_title
set form_mode [ad_decode [ad_form_new_p -key id] 1 "edit" "display"]

ad_form \
    -name ipa \
    -mode $form_mode \
    -form {
        {return_url:text(hidden),optional
            {value $return_url}
        }
        {phonetic_locale:text(hidden),optional
            {value $phonetic_locale}
        }
        {id:key}
        {phonetic_symbol:text 
        {label Symbol}
        {html {size 1}}
    }
} -edit_request {

    db_1row ipa_select {
        select phonetic_symbol
          from vocab_phonetic
         where id = :id
    }
    set page_title "$phonetic_symbol"
    append context $page_title

} -new_data {

    set user_id [auth::require_login]
    db_dml ipa_insert {
        insert into vocab_phonetic
        (phonetic_symbol,locale)
        values (:phonetic_symbol,:phonetic_locale)
    }

} -edit_data {

    auth::require_login
    db_dml ipa_edit {
        update vocab_phonetic
           set phonetic_symbol   = :phonetic_symbol,
        where id = :id
    }

} -after_submit {

    ad_returnredirect $return_url
    ad_script_abort

} -validate {

    {phonetic_symbol
        { [expr [string length $phonetic_symbol] == 1] }
        "Symbol must be one character"
    }

}

# fix null ids here instead of in page contract because doing it in page contract screws
# up ad_form's assumptions
if { ![exists_and_not_null id] } {
    set id ""
}