ad_page_contract {
    
    Front page for vocabulary admin
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: locale.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
    
} {
    {return_url "."}
}

set page_title "Language Defaults"
set context [list $page_title]
vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set locale_options [vocab::locale_list -all all]

ad_form \
    -name locale \
    -on_request {
        set package_locale [lang::user::locale -package_id $package_id]
    } -form {
        {locale_a:text(select)
            {label "Foreign Language"}
            {options $locale_options}
            {help_text "Default language for new words and questions."}
        }
        {locale_b:text(select)
            {label "Native Language"}
            {options $locale_options}
            {help_text "Default language for new definitions and answers."}
        }
        {package_locale:text(select)
            {label Locale}
            {options $locale_options}
            {help_text "Language for program interface."}
        }
    } -validate {
        # just in case
        { locale_a
            { [catch ad_locale_get_label $locale_a] }
            "$locale_a is not a valid locale"
        }
        { locale_b
            { [catch ad_locale_get_label $locale_b] }
            "$locale_b is not a valid locale"
        }
    } -on_submit {
        # we assume this data has been validated 
        ad_set_cookie locale_a $locale_a
        ad_set_cookie locale_b $locale_b
        lang::user::set_locale -package_id $package_id $package_locale
    } -after_submit {
        ad_returnredirect $return_url
        ad_script_abort
    }
