ad_page_contract {
    
    Form for editing a definition.
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: definition-edit.tcl,v 1.1.1.1 2004/02/23 23:00:09 joela Exp $
    
} {
    word_id:integer,optional
    id:integer,optional
} -validate {
    some_id_provided {
        if { ![exists_and_not_null word_id] } {
            if { [exists_and_not_null id] } {
                set word_id [db_string get_word_id "select word_id 
                                                     from vocab_definition
                                                    where id = :id"]
            } else {
                ad_complain "Neither id nor word_id provided."
            }
        }
    }
}

set page_title "Add a Definition"
set word_title [db_string word_title_select "select word from vocab_word where id=:word_id"]
set context [list [list [export_vars -base "word-edit" { {id $word_id} }] $word_title]]

vocab::conn
set subnavbar_link [vocab::subnav_prep -package_id $package_id]

set locale_options [vocab::locale_list -all all]

set form_mode [ad_decode [ad_form_new_p -key id] 1 "edit" "display"]
ad_form \
    -name definition \
    -mode $form_mode \
    -form {
        {word:text(inform)}
        {id:key}
        {word_id:integer(hidden)}
        {definition:text}
        {locale:text(select)
            {label Locale}
            {options $locale_options}
            {value $locale_b}
        }
    } -new_request {

        set page_title "Add a definition"
        lappend context $page_title

    } -edit_request {

	vocab::word::def::get -id $id -array def_array
        set word $def_array(word)
        set definition $def_array(definition)
        set locale $def_array(locale)

        set page_title "Edit Definition"
        lappend context $page_title

    } -new_data {
        
        auth::require_login
        vocab::word::def::new \
            -word_id $word_id \
            -locale $locale_b \
            -definition $definition
        
    } -edit_data {
        
        auth::require_login
        db_dml ipa_edit {
            update vocab_definition
            set word_id = :word_id,
            locale = :locale_b,
            definition = :definition
            where id = :id
        }
        
    } -after_submit {
        
        ad_returnredirect [export_vars -base "word-edit" { { id $word_id } }]
        ad_script_abort
        
    }