ad_library {
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-20
    @cvs-id $Id: util-procs.tcl,v 1.2 2004/02/24 13:58:50 joela Exp $
    
}

######################################################################
# vocab
######################################################################

namespace eval vocab {}

######################################################################
ad_proc -public vocab::subnav_prep {
    -package_id
} {
    Build html for package-specific navigation.  This is architecturally dirty,
    because we should use an adp includelet instead, but this will do for now.

    @author Joel Aufrecht
    @creation-date 2004-02-09
    @return html 
    
} {
    # for now, cheat and grab these variables from the ether.  This is bad
    # because it assumes vocab::conn is always called before this proc
    # hmm, maybe it's better to call vocab::conn from here?  naw, that
    # would make all the upvaring confusing
    upvar label_a  label_a
    upvar label_b  label_b

    set base_url [apm_package_url_from_key vocabulary]
    set locale_url [export_vars -base "locale"]

    lappend linklist [list [export_vars -base ${base_url}word-list] "Words"]
    lappend linklist [list [export_vars -base ${base_url}sentence-list] "Sentences"]
    lappend linklist [list [export_vars -base ${base_url}test-list] "Tests"]
    lappend linklist [list [export_vars -base ${base_url}test] "Random Test"]
    lappend linklist [list [export_vars -base ${base_url}$locale_url] "($label_a"]
    lappend linklist [list [export_vars -base ${base_url}$locale_url] "--> $label_b)"]
    if { [permission::permission_p -object_id $package_id -privilege admin]} {
        lappend linklist { admin/ "Admin"}
    }
    lappend linklist [list [export_vars -base ${base_url}doc] "Help"]

    foreach link $linklist {
        lappend subnav "<a href=\"[lindex $link 0]\">[lindex $link 1]</a>"
    }

    set subnav [join $subnav " &nbsp;&nbsp;  "]

    return $subnav
}

######################################################################
ad_proc -public vocab::conn {
} {
    Set some variables that might be in cookies or might be passed in.

    @author Joel Aufrecht
    @creation-date 2004-02-09
    @return 0 for success, and upvar some variables.
} {
    upvar package_id package_id
    upvar user_id user_id
    set user_id [auth::get_user_id]
    if { ![exists_and_not_null package_id]} {
        set package_id [ad_conn package_id]
    }

    upvar locale_a locale_a
    upvar locale_b locale_b
    upvar label_a  label_a
    upvar label_b  label_b

    set locale [lang::user::locale -package_id $package_id ]

    # we can't rely on lang::user::locale to give us back a valid locale
    if { ![exists_and_not_null locale] } {
        set locale en_US
    }

    if { ![exists_and_not_null locale_a] } {
        set locale_a [ad_get_cookie locale_a $locale]
    }

    if { ![exists_and_not_null locale_b] } {
        set locale_b [ad_get_cookie locale_b $locale]
    }

    # since these are tamper_susceptible cookies, check them for bad data
    if { [catch {set label_a [ad_locale_get_label $locale_a] } ] } {
        set locale_a [lang::user::locale]
        set label_a  [ad_locale_get_label $locale_a ]
    }

    if { [catch {set label_b [ad_locale_get_label $locale_b] } ] } {
        set locale_b [lang::user::locale]
        set label_b  [ad_locale_get_label $locale_b ]
    }

    return 0
}

######################################################################
ad_proc -public vocab::locale_list {
    {-all}
} {
    Get a list of all locales in use
    TODO: not package_aware

    @author Joel Aufrecht
    @creation-date 2004-02-02
    @return list of pairs of label and locale
} {

    if {[exists_and_not_null all] } {
        set where_clause ""
    } else {
        set where_clause "where al.locale in (select distinct locale 
                                                from vocab_word
                                               UNION 
                                              select distinct locale2
                                                from vocab_sentence) "
    }
    return [db_list_of_lists locales "
    select al.label,
           al.locale
      from ad_locales al
        $where_clause
        order by label"]
}


######################################################################
ad_proc -public vocab::letter_list {
} {
    Cheesy proc used for half-assed pagination

    @author Joel Aufrecht
    @creation-date 2004-02-22
    @return list of pairs of letters and labels
} {
    set result [list]
    foreach letter {a b c d e f g h i j k l m n o p q r s t u v w x y z} {
        lappend result [list $letter $letter]
    }
    return $result
}

######################################################################
ad_proc -public vocab::phonetic_alphabet_for_locale {
    {-locale ""}
} {
    This could theoretically be an extra attribute in locales, or even a new table to allow multiple phonetic alphabets per locale, but this is simpler:
 
    @return name of phonetic alphabet for locale
} {
    return [switch $locale {
        "" {format "International Phonetic Alphabet"}
        da_DK {format "Dania"}
        en_US {format "none"}
        ch_ZH {format "Pinyin"}
        ch_zh {format "Pinyin"}
        default  {format "Phonetic Alphabet for $locale"}
    }]
}    



ad_proc -public vocab::csv2list {
    -str 
    {-sepChar ,}
} {
    Split a CSV into a list.
    http://mini.net/tcl/721.html

    @return A list.
} {
    regsub -all {(\A\"|\"\Z)} $str \0 str
    set str [string map [list $sepChar\"\"\" $sepChar\0\" \
                              \"\"\"$sepChar \"\0$sepChar \
                              $sepChar\"\"$sepChar $sepChar$sepChar \
                              \"\" \" \" \0 ] $str]
    set end 0
    while {[regexp -indices -start $end {(\0)[^\0]*(\0)} $str \
            -> start end]} {
        set start [lindex $start 0]
        set end   [lindex $end 0]
        set range [string range $str $start $end]
        set first [string first $sepChar $range]
        if {$first >= 0} {
            set str [string replace $str $start $end \
                [string map [list $sepChar \1] $range]]
        }
        incr end
    }
    set str [string map [list $sepChar \0 \1 $sepChar \0 {} ] $str]
    return [split $str \0]
}

######################################################################
# vocab::locale
######################################################################

namespace eval vocab::locale {}

ad_proc -public vocab::locale::pinyin_num_to_unicode {
    -string:required
} {
    Replaces pinyin in plain ascii and numbers for tone markers with Unicode.  Inspired by:
    
    Pinyin to Unicode Converter
    Copyright (C) 2002  Konrad Mitchell Lawson
    http://www.foolsworkshop.com/
    http://konrad.lawson.net/
    
    @return A unicode string.
} {  
    ####################################
    # step 1:
    # deal with any ending consonants before the tone number
    # ie, turn cian1 into cia1n
    # 1 is a preceeding vowel, if any, in a multi-vowel set
    # 2 should be exactly one vowel (assume the last vowel is always the 
    #                                one to get the tone)
    # 3 is anything after the last vowel and before the first number
    # 4 is exactly 1 number between 1 and 4
    
    regsub -all {([aeiou]*)([aeiou]{1}?)(.*)([1-4]{1}?)} $string {\1\2\4\3} newstring
    #            (1       )(2          )(3 )(4        )

    ####################################
    # step 2:
    # convert numeric pinyin to Unicode
    
    array set charMap {
        a1 ā
        a2 á
        a3 ǎ
        a4 à
        e1 ē
        e2 é
        e3 ě
        e4 è
        i1 ī
        i2 í
        i3 ǐ
        i4 ì
        o1 ō
        o2 ó
        o3 ǒ
        o4 ò
        u1 ū
        u2 ú
        u3 ǔ
        u4 ù
        ü1 ǖ
        ü2 ǘ
        ü3 ǚ
        ü4 ǜ
    }

    set string_unicode [string map -nocase [array get charMap] $newstring]
    return $string_unicode
}

ad_proc -public  vocab::locale::moby_ascii_to_ipa {
    -string:required
} {

    Replaces moby's ascii representation of IPA with unicode.  Depending on how standard moby's ascii ipa is, this could be pretty general. This is the second one of these; maybe I should build a general framework proc.  Oh head, and this is INCOMPLETEly implemented at the moment.  (Thanks emacs for making it nearly impossible to open, edit, and save a simple utf-8 file!)
    http://www.dcs.shef.ac.uk/research/ilash/Moby/mpron.html

} {

    # should stress markers go before or after the modified letter?
    # leave it alone for now, but maybe fix it later
    # there's a good chance that this regsub will fix it:
    # regsub -all {.*{1}?)([12]{1}?)} $string {\2\1} newstring

    array set charMap {
        0 {}
        1 
        2 
        & æ  
    }
# (@)   "a" in "air"
# A     "a" in "far"
# eI    "a" in "day"
# @     "a" in "ado"
#         or the glide "e" in "system" (dipthong schwa)
# -     "ir" glide in "tire"
#         or the  "dl" glide in "handle"
#         or the "den" glide in "sodden" (dipthong little schwa)
# b     "b" in "nab"
# tS    "ch" in "ouch"
# d     "d" in "pod"
# E     "e" in "red"
# i     "e" in "see"
# f     "f" in "elf"
# g     "g" in "fig"
# h     "h" in "had"
# hw    "w" in "white"
# I     "i" in "hid"
# aI    "i" in "ice"
# dZ    "g" in "vegetably"
# k     "c" in "act"
# l     "l" in "ail"
# m     "m" in "aim"
# N     "ng" in "bang"
# n     "n" in "and"
# Oi    "oi" in "oil"
# A     "o" in "bob"
# AU    "ow" in "how"
# O     "o" in "dog"
# oU    "o" in "boat"
# u     "oo" in "too"
# U     "oo" in "book"
# p     "p" in "imp"
# r     "r" in "ire"
# S     "sh" in "she"
# s     "s" in "sip"
# T     "th" in "bath"
# D     "th" in "the"
# t     "t" in "tap"
# @     "u" in "cup"
# @r    "u" in "burn"
# v     "v" in "average"
# w     "w" in "win"
# j     "y" in "you"

# Z     "s" in "vision"
# z     "z" in "zoo"

# Stress or emphasis is marked in the data with the primary "'" or secondary "," marks: "'" (uncurled apostrophe) marks primary stress "," (comma) marks secondary stress. Moby Pronunciator contains many common names and phrases borrowed from other languages; special sounds include (case is significant):

# "A"  "a" in "ami"
# "N"  "n" in "Francoise"
# "R"  "r" in "Der"
# x  "ch" in "Bach"
# y  "eu" in "cordon bleu"
# "Y"  "u" in "Dubois"

    set string_unicode [string map -nocase [array get charMap] $newstring]
    return $string_unicode
}


######################################################################
# vocab::img
######################################################################

namespace eval vocab::img {}


ad_proc -public vocab::img::checkedbox {
} {
    @return HTML for a checked checkbox image
} {
    return  {<img src="/shared/images/checkboxchecked" height="13" width="13" border="0" style="background-color: white;">}
}

ad_proc -public vocab::img::checkbox {
} {
    @return HTML for a checkbox image
} {
    return {<img src="/shared/images/checkbox" height="13" width="13" border="0" style="background-color: white;">}
}

ad_proc -public vocab::img::help {
} {
    @return HTML for help icon
} {
    return {<img src="/shared/images/info.gif" width="12" height="9" alt="[i]" title="Help text" border="0">}
}

