ad_library {
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-01
    @cvs-id $Id: vocabulary-procs.tcl,v 1.1.1.1 2004/02/23 23:00:08 joela Exp $
}
    
aa_register_case -cats { smoke api } \
    -procs {
        vocab::word::new  
        vocab::word::get
        vocab::word::edit
        vocab::word::delete
    } \
 vocabulary__word_basic_tests {
        Put some sample data in and then retrieve it.
    } {
        aa_run_with_teardown \
            -rollback \
            -test_code  {   
    # use auto-test package id to avoid polluting any real instances
    set package_id [ad_conn package_id]
    aa_log "package_id is $package_id"
    set user_id [auth::require_login]
    
    #-----------------------------------------------------------------
    # Generate test data
    #-----------------------------------------------------------------

    set word "test-wordæ[ad_generate_random_string]"
    set locale en_US
    set ipa_phonetic "test-ipa-phoneticø[ad_generate_random_string]"
    set local_phonetic "test-local-phoneticæ[ad_generate_random_string]"
    set def_locale da_DK
    set def_list [list "test-def1[ad_generate_random_string]" "test-def2[ad_generate_random_string]"]

    #-----------------------------------------------------------------
    # New Record
    #-----------------------------------------------------------------
    
    set new_id [vocab::word::new \
                    -package_id $package_id \
                    -word $word \
                    -locale $locale \
                    -ipa_phonetic $ipa_phonetic \
                    -local_phonetic $local_phonetic \
                    -user_id $user_id \
                    -def_locale $def_locale \
                    -def_list $def_list
               ]
    aa_true "Creation succeeds" [exists_and_not_null new_id]
    aa_log "new_id is $new_id"

    #-----------------------------------------------------------------
    # Retrieve Record
    #-----------------------------------------------------------------

    vocab::word::get \
        -id $new_id \
        -array test_array  -locale_b $def_locale
    
    aa_equals "Word match is successful" $test_array(word) $word
    aa_equals "ipa_phonetic match is successful" $test_array(ipa_phonetic) $ipa_phonetic
    aa_equals "local_phonetic match is successful" $test_array(local_phonetic) $local_phonetic
    aa_equals "definition is successful" [join $test_array(definitions)] $def_list

    #-----------------------------------------------------------------
    # Edit Record
    #-----------------------------------------------------------------

    set word_edit "test-wordæ[ad_generate_random_string]"
    set locale_edit en_US
    set ipa_phonetic_edit "test-ipa-phoneticø[ad_generate_random_string]"
    set local_phonetic_edit "test-local-phoneticæ[ad_generate_random_string]"
    
    set edit_id [vocab::word::edit \
                     -id $new_id \
                     -word $word_edit \
                     -locale $locale_edit \
                     -ipa_phonetic $ipa_phonetic_edit \
                     -local_phonetic $local_phonetic_edit]

    aa_equals "Edit succeeds" $edit_id $new_id 
    # to be pedantic, should also check that neither is null or 0, within the same test

    #-----------------------------------------------------------------
    # Retrieve Edited
    #-----------------------------------------------------------------

    vocab::word::get \
        -id $new_id \
        -array test_edit_array
    
    aa_equals "Word match is successful" $test_edit_array(word) $word_edit
    aa_equals "ipa_phonetic_edit match is successful" $test_edit_array(ipa_phonetic) $ipa_phonetic_edit
    aa_equals "local_phonetic_edit match is successful" $test_edit_array(local_phonetic) $local_phonetic_edit

    #-----------------------------------------------------------------
    # Delete 
    #-----------------------------------------------------------------

    set delete_id [vocab::word::delete \
                       -id $new_id]

    aa_equals "Delete succeeds" $delete_id 0

    set after_delete_id [vocab::word::get \
                             -id $new_id \
                             -array after_delete_array]

    aa_equals "Cannot retrieve deleted row" $after_delete_id -1
    aa_false "Retrieved array should be empty" [array exists after_delete_array]
    }
}

aa_register_case -cats { smoke api } \
    -procs {
        vocab::sentence::new  
        vocab::sentence::get
        vocab::sentence::edit
        vocab::sentence::delete
    } \
 vocabulary__sentence_basic_tests {
        Put some sample data in and then retrieve it.
    } {
        aa_run_with_teardown \
            -rollback \
            -test_code  {   
    # use auto-test package id to avoid polluting any real instances
    set package_id [ad_conn package_id]
    aa_log "package_id is $package_id"
    set user_id [auth::require_login]
    
    #-----------------------------------------------------------------
    # Generate test data
    #-----------------------------------------------------------------

    set text "test sentence [string tolower [ad_generate_random_string]]"
    set locale en_US
    set word_list test_word_list

    #-----------------------------------------------------------------
    # New Record
    #-----------------------------------------------------------------
    
    set new_id [vocab::sentence::new \
                    -package_id $package_id \
                    -user_id $user_id \
                    -text $text \
                    -locale $locale \
                    -word_list $word_list]

    aa_true "Creation succeeds" [exists_and_not_null new_id]
    aa_log "new_id is $new_id"

    #-----------------------------------------------------------------
    # Retrieve Record
    #-----------------------------------------------------------------

    vocab::sentence::get \
        -id $new_id \
        -array test_array
    
    aa_equals "Sentence match is successful" $test_array(text) $text
    aa_equals "locale match is successful" $test_array(locale) $locale
    aa_equals "word list is correct" $test_word_list [split $text]

    #-----------------------------------------------------------------
    # Edit Record
    #-----------------------------------------------------------------

    set text_edit "test sentenceæ [ad_generate_random_string]"
    set locale_edit en_US
    
    set edit_id [vocab::sentence::edit \
                     -id $new_id \
                     -text $text_edit \
                     -locale $locale_edit]

    aa_equals "Edit succeeds" $edit_id $new_id 

    #-----------------------------------------------------------------
    # Retrieve Edited
    #-----------------------------------------------------------------

    vocab::sentence::get \
        -id $new_id \
        -array test_edit_array
    
    aa_equals "Sentence match is successful" $test_edit_array(text) $text_edit
    aa_equals "Locale match is successful" $test_edit_array(locale) $locale_edit
    #-----------------------------------------------------------------
    # Delete 
    #-----------------------------------------------------------------

    set delete_id [vocab::sentence::delete \
                       -id $new_id]

    aa_equals "Delete succeeds" $delete_id 0

    set after_delete_id [vocab::sentence::get \
                             -id $new_id \
                             -array after_delete_array]

    aa_equals "Cannot retrieve deleted row" $after_delete_id -1
    aa_false "Retrieved array should be empty" [array exists after_delete_array]
    }
}

aa_register_case vocabulary__put_and_get_sentence {
    Put some sample data in and then retrieve it.
} {
    aa_log "If you are only seeing this test case, it's because you don't have acs-automatic-testing 5.1 or greater and so you can't see the other cases."
}
    


    

