# packages/vocabulary/tcl/vocabulary-sentence.tcl

ad_library {
    
    Procs for sentences.
    
    @author Joel Aufrecht (joel@aufrecht.org)
    @creation-date 2004-02-22
    @cvs-id $Id: sentence-procs.tcl,v 1.1.1.1 2004/02/23 23:00:07 joela Exp $
    
}


#####################################################################
# vocab::sentence
######################################################################

namespace eval vocab::sentence {}

#---------------------------------------------------------------------
ad_proc -public vocab::sentence::get {
    -id:required
    -array:required
} { 
    Retrieve a sentence
    @param id The id of the sentence
    @array The name of an array to populate with sentence data

    @return 0 for success, -1 if no row
} {
    upvar 1 $array row
    set got_sentence [db_0or1row sentence_select {
	select vs.locale2 as locale,
               cr.content as text
          from cr_items ci,
               cr_revisions cr,
               vocab_sentence vs
         where ci.item_id = :id
           and cr.revision_id = ci.live_revision
           and vs.id = ci.live_revision
    } -column_array row]
    if { $got_sentence } {
        return 0
    } else {
        return -1
    }
}

#---------------------------------------------------------------------
ad_proc -public vocab::sentence::new {
    -user_id:required
    -package_id:required
    -text:required
    -locale:required
    -word_list
    -group
    {-sort_order 0}
} { 
    This proc adds a sentence.

    @param word_list The name of a list to populate with the sentence's words. 
    @param group The id of a test of type 'sentence_group' to associate this sentence with.
    @return new sentence object id.
} {

    set name vocab_sentence[db_nextval vocab_sentence_name_seq]
    db_transaction {
	set id [db_string sentence_insert {
	    select content_item__new(:name,-100,null,null,null,:user_id,:package_id,null,'content_item','vocab_sentence',null,null,null,null,null)
	}]

	set revision_id [db_nextval acs_object_id_seq]
	if { $sort_order == 0} {
            set sort_order [db_string get_next_sort "
                                select max(sort_order) + 1
                                  from vocab_sentence"]
        }
	db_dml revision_add {
 	    insert into vocab_sentencei (item_id, revision_id, text, locale2, sort_order) 
	    values (:id, :revision_id, :text, :locale, :sort_order)
	}

	db_exec_plsql make_live {
	    select content_item__set_live_revision(:revision_id)
	}

        # should probably regexp for all non-alpha
        if { [exists_and_not_null word_list] } {
            upvar 1 $word_list extracted_words
            foreach word [split $text {.;,! ?}] {
                if {[exists_and_not_null word] } {
                    lappend extracted_words [string tolower $word]
                }
            }
        } else {
            set extracted_words [list]
        }

    }
    return $id
}


#---------------------------------------------------------------------
ad_proc -public vocab::sentence::edit {
    -id:required
    -text:required
    -locale:required
    {-sort_order 0}
} { 
    This proc edits a sentence.
    @return the id of the sentence.
} {
    db_transaction {
	set revision_id [db_nextval acs_object_id_seq]
	
	db_dml revision_add {
 	    insert into vocab_sentencei (item_id, revision_id, text, locale2, sort_order)
	    values (:id, :revision_id, :text, :locale, :sort_order)
	}

	db_exec_plsql make_live {
	    select content_item__set_live_revision(:revision_id)
	}
    }
    return $id
}

#---------------------------------------------------------------------
ad_proc -public vocab::sentence::delete {
    -id:required
} { 
    This proc deletes a sentence.
    @return 0 for success
} {
    auth::require_login
    db_exec_plsql note_delete {
	select content_item__delete(:id)
    }
    return 0
}
