ad_page_contract {
    includelet for word list
} {
    orderby:optional
    locale:optional
    {return_url "."}
}

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set user_id [auth::get_user_id]
set vocab_url [apm_package_url_from_key vocabulary]
set return_url [export_vars -base [ad_conn url] {locale orderby}]
#set action2 [list "Add a new word" [export_vars -base word-add-wizard] "Add a new word"]

template::list::create \
    -name words \
    -multirow words \
    -elements {
        on_list {
            label "On your list"
            display_template {
                @words.on_list_html;noquote@
            }
	    orderby {on_list}
        }
        word {
            label "Word"
	    orderby {lower(word)}
        }
        locale {
	    label "Word Locale"
	    orderby {locale}
	}
        ipa_phonetic {
	    label "IPA Phonetic"
	    orderby {ipa_phonetic}
	}
        local_phonetic {
	    label "Local Phonetic"
	    orderby {local_phonetic}
	}
    } \
    -filters {
	locale {
	    label "Locale"
	    where_clause {
		al.locale = :locale
	    }
	    values {
                [vocab::locale_list]
	    }
	}
    }

db_multirow \
    -extend {
        on_list_html
    } words word_select "
        select vw.id,
               vw.word,
               al.label as locale,
               vw.ipa_phonetic,
               vw.local_phonetic,
               coalesce((select 1 
                  from vocab_word_list 
                 where word_id = vw.id
                   and user_id = :user_id
                   and package_id = :package_id),0) as on_list
          from vocab_word vw,
               ad_locales al
         where al.locale = vw.locale
	[template::list::filter_where_clauses -name words -and]
	[template::list::orderby_clause -name words -orderby]
    " {
	set delete_url [export_vars -base "word-delete" {id return_url}]
        set add_url [export_vars -base "word-add" {id return_url}]
        if { $on_list } {
            set on_list_html "<a href=\"$delete_url\" title=\"Remove this word\"><img src=\"/shared/images/checkboxchecked\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></a>"
        } else {
            set on_list_html "<a href=\"$add_url\" title=\"Add this word\"><img src=\"/shared/images/checkbox\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></a>"
        }
    }