ad_page_contract {
    includelet for word list
} {
    locale_b:optional
    locale:optional
    orderby:optional
    {paginate "a"}
    return_url:optional
}

# doing this here instead of page_contract because defaults work
# unexpectedly in page contract in includelet
if { ![exists_and_not_null return_url] } {
    set return_url [ad_conn url][ad_conn query]
}

# do some cheap-ass pagination until somebody explains to me how to
# use Jon Griffin's paginator from within a template::list

set paginate_like $paginate%    
vocab::conn
set action [list "Add a word" [export_vars -base word-edit {return_url}] "Add a word"]
set action [concat $action [list "Import word list" [export_vars -base word-list-add {return_url}] "Import a word list"]]
set locale_b_label [ad_locale_get_label $locale_b]
template::list::create \
    -name words \
    -multirow words \
    -actions $action \
    -elements {
        word {
	    link_url_col edit_url
            label "Word"
	    orderby {lower(word)}
        }
        phonetic {
            label ""
	    sub_class narrow
        }
        label {
	    label "Locale"
	    orderby {lower(al.locale)}
	}
        definition {
            label "Meaning in [set locale_b_label]"
        }
        on_list {
            label "On your list"
            display_template {
                @words.on_list_html;noquote@
            }
	    orderby {on_list}
        }
	delete {
	    link_url_col delete_url 
	    display_template {
		<img src="/resources/acs-subsite/Delete16.gif" width="16" height="16" border="0">
	    }
	    sub_class narrow
	}

    } \
    -filters {
	locale {
	    label "Locale"
	    where_clause {
		al.locale = :locale
	    }
	    values {
                [vocab::locale_list]
	    }
	}
	paginate {
	    label "Letter"
	    where_clause "
		(vw.word like :paginate_like or vw.local_phonetic like :paginate_like)
	    "
	    values {
                [vocab::letter_list]
	    }
	}
    }

db_multirow \
    -extend {
	edit_url
	delete_url
        on_list_html
    } words word_select "
        select vw.id,
               vw.word,
               al.label as label,
               coalesce(local_phonetic,ipa_phonetic) as phonetic,
               (select substring(definition,0,20)
                  from vocab_definition
                 where word_id = vw.id
                   and locale = :locale_b
                 limit 1) as definition,
               coalesce((select 1 
                  from vocab_word_list 
                 where word_id = vw.id
                   and user_id = :user_id
                   and package_id = :package_id),0) as on_list
          from vocab_word vw,
               ad_locales al
         where vw.package_id = :package_id
           and al.locale = vw.locale
	[template::list::filter_where_clauses -name words -and]
	[template::list::orderby_clause -name words -orderby]
    " {
	set edit_url [export_vars -base "word-edit" {id}]
	set delete_url [export_vars -base "word-delete" {id return_url}]

	set delete_train_url [export_vars -base "word-train-delete" {id return_url}]
        set add_train_url [export_vars -base "word-train-add" {id return_url}]
        if { $on_list } {
            set on_list_html "<a href=\"$delete_train_url\" title=\"Remove this word\">[vocab::img::checkedbox]</a>"
        } else {
            set on_list_html "<a href=\"$add_train_url\" title=\"Add this word\">[vocab::img::checkbox]</a>"
        }
    }

