ad_page_contract {
    includelet for word list
} {
    orderby:optional
    locale:optional
    test_type:optional
    {return_url "."}
}

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set user_id [auth::get_user_id]

set return_url [export_vars -base [ad_conn url] {test_type orderby locale return_url}]

template::list::create \
    -name tests \
    -multirow tests \
    -elements {
        id {
            link_url_col test_url
            label "Test"
        }
        test_type {
            label "Type"
        }
        result_count {
            label "Count"
        }
        result_sum {
            label "Sum"
        }
        score {
            label "Average"
        }

        last_five {
            label "Last 5"
        }
    } \
    -filters {
	test_type {
	    label "Test Type"
	    where_clause {
		vt.test_type = :test_type
	    }
	    values {
                [vocab::train::test_type_list]
	    }
	}
    }

# TODO: this query is not package-away - should join with tests as well
# get all tests with results or on the test list
# TODO: this query needs more help
db_multirow -extend { test_url test_train_add_url test_train_delete_url on_list_html score last_five } tests select_tests "
    select vt.id,
           max(vt.test_type) as test_type,
           coalesce(count(vtr.answer1),0) as result_count,
           coalesce(sum(vtr.result1),0) as result_sum
      from vocab_test vt 
             inner join vocab_test_result vtr on vtr.test_id = vt.id and vtr.user_id = :user_id
	[template::list::filter_where_clauses -name tests -and]
     group by vt.id
    UNION
    select vt.id,
           max(vt.test_type) as test_type,
           0 as result_count,
           0  as result_sum
      from vocab_test vt 
             inner join vocab_user_test_map vutm on vutm.test_id = vt.id and vutm.user_id = :user_id
	[template::list::filter_where_clauses -name tests -and]
     group by vt.id
	[template::list::orderby_clause -name tests -orderby]
" {
    set test_train_add_url [export_vars -base "test-train-add" {id return_url}]
    set test_train_delete_url [export_vars -base "test-train-delete" {id return_url}]
    set test_url [export_vars -base "test" {{test_id $id} test_type }]
    if { $result_count > 0} {
	set score "[expr {$result_sum * 100} / $result_count]%"
    } else {
	set score "n/a"
    }
    
#    if { $result_five_count == 5 } {
#        set last_five [expr ($result_sum * 100) / 5]
#    } else {
        set last_five ""
#    }

}