ad_page_contract {
    includelet for word list
} {
    orderby:optional
    locale_filter:optional
    test_type_filter:optional
    {result_count_filter ""}
    {return_url "."}
}

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set user_id [auth::get_user_id]

set return_url [export_vars -base [ad_conn url] {test_type orderby locale return_url}]

template::list::create \
    -name tests \
    -multirow tests \
    -elements {
        on_list {
            label "On your list"
            display_template {
                @tests.on_list_html;noquote@
            }
	    orderby {on_list}
        }
        question {
            link_url_col test_url
            display_template {
                @tests.question;noquote@
            }
            label "Test"
	    orderby {question}
        }
        result_count {
            label "Count"
	    orderby {result_count}
        }
        result_sum {
            label "Sum"
	    orderby {result_sum}
        }
	delete {
	    link_url_col test_delete_url 
	    display_template {
		<img src="/resources/acs-subsite/Delete16.gif" width="16" height="16" border="0">
	    }
	    sub_class narrow
	}
    } \
    -filters {
	locale_filter {
	    label "Locale"
	    where_clause {
		vt.locale_a = :locale_filter
	    }
	    values {
                [vocab::locale_list]
	    }
	}
	test_type {
	    label "Test Type"
	    where_clause {
		vt.test_type = :test_type_filter
	    }
	    values {
                [vocab::train::test_type_list]
	    }
	}
    }

db_multirow -extend { test_url test_train_add_url test_train_delete_url on_list_html test_delete_url } tests select_tests "
    select vt.id,
           vt.test_type,
           coalesce((select 1 
                       from vocab_user_test_map
                      where test_id = vt.id
                        and user_id = :user_id),0) as on_list,
           question,
           coalesce((select count(*) 
                       from vocab_test_result
                      where test_id = vt.id
                        and user_id = :user_id),0) as result_count,
           coalesce((select sum(result1) 
                       from vocab_test_result
                      where test_id = vt.id
                        and user_id = :user_id),0) as result_sum
      from vocab_test vt
     where package_id = :package_id
	[template::list::filter_where_clauses -name tests -and]
	[template::list::orderby_clause -name tests -orderby]
limit 500
" {
    set test_train_add_url [export_vars -base "test-train-add" {id return_url}]
    set test_train_delete_url [export_vars -base "test-train-delete" {id return_url}]
    set test_url [export_vars -base "test" {{test_id $id} test_type }]
    set test_delete_url [export_vars -base "test-delete" {id return_url}]

    if { $on_list } {
        set on_list_html "<a href=\"$test_train_delete_url\" title=\"Remove this test\"><img src=\"/shared/images/checkboxchecked\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></a>"
    } else {
        set on_list_html "<a href=\"$test_train_add_url\" title=\"Add this test\"><img src=\"/shared/images/checkbox\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></a>"
    }

}