ad_page_contract {
    includelet for sentence list
} {
    orderby:optional
    locale:optional
    {return_url "."}
    {group ""}
}

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set user_id [auth::get_user_id]
set vocab_url [apm_package_url_from_key vocabulary]
set return_url [export_vars -base [ad_conn url] {locale orderby}]
#set action [list "Add a new sentence" [export_vars -base sentence-add-wizard] "Add a new sentence"]
set action [list "Add a group of sentences" [export_vars -base sentence-group-add] "Add a group of sentences"]

template::list::create \
    -name sentences \
    -multirow sentences \
    -actions "$action" \
    -elements {
        on_list {
            label "On your list"
            display_template {
                @sentences.on_list_html;noquote@
            }
	    orderby {on_list}
        }
        sentence {
            label "Sentence"
	    orderby {lower(sentence)}
        }
        locale {
	    label "Sentence Locale"
	    orderby {locale}
	}
	edit {
	    link_url_col edit_url 
	    display_template {
		<img src="/resources/acs-subsite/Edit16.gif" width="16" height="16" border="0">
	    }
	    sub_class narrow
	}
    } \
    -filters {
	locale {
	    label "Locale"
	    where_clause {
		al.locale = :locale
	    }
	    values {
                [vocab::locale_list]
	    }
	}
    }

if { [exists_and_not_null group] } {
    set group_clause " and ci.item_id in (select subject_id from vocab_test_subject where test_id = :group)"
} else {
    set group_clause ""
}

db_multirow \
    -extend {
        on_list_html
        edit_url
    } sentences sentence_select "
        select ci.item_id as id,
               vs.sort_order,
               cr.content as sentence,
               al.label as locale,
               coalesce((select 1
                  from vocab_test 
                 where test_type='sentence'
                   and test_subject = ci.item_id),0) as on_list      
          from vocab_sentence vs,
               cr_items ci,
               cr_revisions cr,
               ad_locales al
         where ci.content_type = 'vocab_sentence'
           and cr.revision_id = ci.live_revision
           and vs.id = ci.live_revision
           and al.locale = vs.locale2
               $group_clause
	[template::list::filter_where_clauses -name sentences -and]
	[template::list::orderby_clause -name sentences -orderby]
    " {
	set delete_url [export_vars -base "test-delete" {id return_url}]
	set edit_url [export_vars -base "${vocab_url}sentence-edit" {id return_url}]
        set add_url [export_vars -base "sentence-add" {id return_url}]
        if { $on_list } {
            set on_list_html "<a href=\"$delete_url\" title=\"Remove this sentence\"><button style=\"margin: 1px; padding: 2px; border-width: thin;\"><img src=\"/shared/images/checkboxchecked\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></button></a>"
        } else {
            set on_list_html "<a href=\"$add_url\" title=\"Add this sentence\"><button style=\"margin: 1px; padding: 2px; border-width: thin;\"><img src=\"/shared/images/checkbox\" height=\"13\" width=\"13\" border=\"0\" style=\"background-color: white;\"></button></a>"
        }
    }