# expects phonetic_locale
# expects working_locale
# button_target:optional

set package_id [ad_conn package_id]
if { [exists_and_not_null button_target ] } { 
    set buttons 1
} else {
    set buttons 0
}

# are we doing IPA or local?
if { [exists_and_not_null phonetic_locale] } {
    # we're doing a local phonetic
    set where_clause "where vp.locale = :phonetic_locale"
    set field "local_phonetic"
} else {
    # we're doing IPA
    set where_clause "where vp.locale is null"
    set field "ipa_phonetic"
}

set add_action [list "Add a Symbol" [export_vars -base phonetic-edit {return_url phonetic_locale} ]]

template::list::create \
    -name phonetic_list \
    -multirow phonetic_list \
    -actions $add_action \
    -elements {
        paste {
	    sub_class narrow
            label "Symbol" 
            display_template "@phonetic_list.paste_html;noquote@"
        }
	example {
	    label "as in"
	}
        edit { 
	    link_url_col edit_url
	    sub_class narrow
            display_template {
                @phonetic_list.edit_html;noquote@
            }
        }
    }

db_multirow \
    -extend {
        view_url
	edit_url
	delete_url
        onClick
        paste_html
        edit_html
    } phonetic_list phonetic_select "
        select vp.id,
               (select word 
                  from vocab_word
                 where $field like '%' || vp.phonetic_symbol || '%'
                   and locale = :working_locale
                   and package_id = :package_id
                 limit 1) as example,
               vp.phonetic_symbol
          from vocab_phonetic vp
        $where_clause
	 order by vp.sort_order, vp.phonetic_symbol
    " {
	set edit_url [export_vars -base "phonetic-edit" {id}]

        if { $buttons } {
	    set onClick "javascript:$button_target+='$phonetic_symbol'"
            set paste_html "<input style=\"margin: 0px; font-size: 1.3em; padding: 0px; width: 2em; border-width: thin;\" type=\"button\" onClick=\"$onClick\" value=\"$phonetic_symbol\" />"
            set edit_html "<img src=\"/resources/acs-subsite/Edit16.gif\" height=\"16\" width=\"16\" border=\"0\" alt=\"Edit\">"
	} else {
	    set onClick ""
            set paste_html "<a href=\"$edit_url\">$phonetic_symbol</a>"
            set edit_html ""
	}
    }

set phonetic_name [vocab::phonetic_alphabet_for_locale -locale $phonetic_locale]

if { [exists_and_not_null csv] } {
    template::list::write_csv -name phonetic_list
}