# expects phonetic_id

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set add_url [export_vars -base "phonetic-example-edit" {phonetic_id return_url}]

template::list::create \
    -name phonetic_example \
    -multirow phonetic_example \
    -actions " {Add an example} $add_url " \
    -no_data "No examples" \
    -elements {
        word { 
	    link_url_col edit_url
            label "Example Word" 
        }
        comments { label "Comments" }
	delete {
	    link_url_col delete_url 
	    display_template {
		<img src="/resources/acs-subsite/Delete16.gif" width="16" height="16" border="0">
	    }
	    sub_class narrow
	}
    }

db_multirow \
    -extend {
	edit_url
	delete_url
    } phonetic_example phonetic_example_select {
        select vw.word,
               vpe.word_id,
               vpe.comments
          from vocab_phonetic_example vpe,
               vocab_word vw
         where vpe.phonetic_id = :phonetic_id
           and vw.id = vpe.word_id

    } {
	set edit_url [export_vars -base "phonetic-example-edit" { {id $word_id} }]
	set delete_url [export_vars -base "phonetic-example-delete" { {id $word_id} }]
    }