ad_page_contract {
    includelet for grouped locale information
} {
    locale_b:optional
    orderby:optional
}

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set action [list "Add a word" [export_vars -base word-edit {return_url}] "Add a word"]

template::list::create \
    -name locale \
    -multirow locale \
    -actions $action \
    -elements {
        locale {
	    label "Locale"
            display_template {
                @locale.locale_label@
            }
	    orderby {locale_label}
	}
        word_count {
	    link_url_col word_locale_url
            label "Words"
	    orderby {word_count}
        }
        sentence_count {
	    link_url_col sentence_locale_url
            label "Sentences"
	    orderby {sentence_count}
        }
        test_count {
	    link_url_col test_locale_url
            label "Tests"
	    orderby {test_count}
        }
    }

# note that the entire query is selected into another query
# with the meaningless name of superquery in order to 
# create a virtual table to which to apply the where clause
db_multirow \
    -extend {
	word_locale_url
	sentence_locale_url
	test_locale_url
    } locale word_select "
        select * from (
        select al.label as locale_label,
               al.locale,
               (select count(*)
                  from vocab_word
                 where locale = al.locale
                   and package_id = :package_id) as word_count,
               (select distinct count(item_id)
                  from vocab_sentencex
                 where locale2 = al.locale) as sentence_count,
               (select count(id)
                  from vocab_test
                 where locale_a = al.locale
                   and package_id = :package_id) as test_count
          from ad_locales al
         group by locale, locale_label) superquery
        where word_count > 0
	[template::list::orderby_clause -name locale -orderby]

    " {
	set word_locale_url [export_vars -base "word-list" {{locale $locale}}]
	set sentence_locale_url [export_vars -base "sentence-list" {{locale $locale}}]
	set test_locale_url [export_vars -base "test-list" {{locale $locale}}]
    }
