# expects word_id
# expect return_url

if { ![info exists package_id] } {
    set package_id [ad_conn package_id]
}

set add_url [export_vars -base "definition-edit" {word_id return_url}]

template::list::create \
    -name definition \
    -multirow definition \
    -actions " {Add a Definition} $add_url " \
    -no_data "No Definitions" \
    -elements {
        definition
        { 
            link_url_col edit_url
            label "Definition" 
        }
        locale {label "Locale"}
	delete {
	    link_url_col delete_url 
	    display_template {
		<img src="/resources/acs-subsite/Delete16.gif" width="16" height="16" border="0">
	    }
	    sub_class narrow
	}
    }

db_multirow \
    -extend {
	edit_url
	delete_url
    } definition definition_select {
        select vd.id,
               substr(vd.definition,0,20) as definition,
               al.label as locale
          from vocab_definition vd,
               ad_locales al
         where vd.word_id = :word_id
           and al.locale = vd.locale
         order by sort_order

    } {
	set edit_url [export_vars -base "definition-edit" { id }]
	set delete_url [export_vars -base "definition-delete" { id return_url}]
    }