# /packages/room-reservation/www/room-search.tcl

ad_page_contract {

    Room Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-search.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {

} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_verify_and_get_user_id]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -rooms_pretty_plural rooms_pretty_plural

set title "Search for $rooms_pretty_plural"
set context $title

form create room_search

element create room_search facility_id \
    -label "$facilities_pretty_name" \
    -datatype integer \
    -widget select \
    -options [linsert [room-reservation::facilities::get_name_id_list_enabled_and_non_empty] 0 [list All 0]] \
    -optional

element create room_search date_start \
    -label "Start on this date" \
    -datatype date \
    -widget date \
    -optional

element create room_search date_end \
    -label "End on this date" \
    -datatype date \
    -widget date \
    -optional

element create room_search start_time \
    -label "Start Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM" \
    -optional

element create room_search end_time \
    -label "End Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM" \
    -optional

element create room_search capacity \
    -label "Seating capacity" \
    -datatype integer \
    -widget text

# Process the form
if {[form is_valid room_search]} {
    template::form get_values room_search facility_id date_start date_end start_time end_time capacity

    # Set up the datetimes
    #set start_date [calendar::to_sql_datetime -date $date -time $start_time -time_p $time_p]
    #set end_date [calendar::to_sql_datetime -date $date -time $end_time -time_p $time_p]

    #set room_search_id [calendar::item::new -start_date $start_date \
    \#        -end_date $end_date \
    \#        -name $title \
    \#        -description $description \
    \#        -calendar_id $calendar_id \
    \#        -item_type_id $item_type_id]

    ad_script_abort
}

# Set some properties
#element set_properties room_search date -value [calendar::from_sql_datetime -sql_date $date -format "YYYY-MM-DD"]

#if {[dt_no_time_p -start_time $start_time -end_time $end_time]} {
#    # No time event
#    element set_properties room_search time_p -value 0
#} else {
#    if {![empty_string_p $start_time]} {
#        set start_time_date [calendar::from_sql_datetime -sql_date $start_time -format {HH24}]
#        element set_properties room_search start_time -value $start_time_date
#    }
#
#    if {![empty_string_p $end_time]} {
#        set end_time_date [calendar::from_sql_datetime -sql_date $end_time -format {HH24}]
#        element set_properties room_search end_time -value $end_time_date
#    }
#
#    element set_properties room_search time_p -value 1
#}

ad_return_template
