# /packages/room-reservation/www/room-reservations.tcl

ad_page_contract {
    
    Shows reservations of a Room

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-reservations.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    room_id:integer,notnull
    {view "list"}
    {date ""}
    {julian_date ""}
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_maybe_redirect_for_registration]

set date [calendar::adjust_date -date $date -julian_date $julian_date]

room-reservation::get_ui_params -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id]

set title "$room_full_name Reservations"
set context [list [list "rooms" $rooms_pretty_plural] [list "room-view?room_id=$room_id" "$room_full_name Info"] $title]

set item_template "<a href=\"reservation-view?reservation_id=\$reservation_id\">\$item</a>"
set day_template "<font size=-1><b>\$day</b> - <a href=\"\?date=\$date&view=day&room_id=$room_id\">\$pretty_date</a>&nbsp;&nbsp;&nbsp;<a href=\"reservation-new?room_id=$room_id&date=\$date\">(Reserve on this date)</a></font>"
set item_add_template "<a href=\"reservation-new?room_id=$room_id&julian_date=\$julian_date\">(Reserve)</a></font>"

switch -exact -- $view {
    {list} {
	set content [room-reservation::calendar::list_display -room_id $room_id \
                         -date $date \
                         -item_template $item_template \
                    ]
    }
    {week} {
	set content [room-reservation::calendar::one_week_display -room_id $room_id \
                         -date $date \
                         -prev_nav_template "<a href=\"?view=week&date=\[ns_urlencode \$last_week]&room_id=$room_id\">&lt;</a>" \
                         -next_nav_template "<a href=\"?view=week&date=\[ns_urlencode \$next_week]&room_id=$room_id\">&gt;</a>" \
                         -item_template $item_template \
			 -day_template $day_template \
                    ]
    }
    {month} {
	set content [room-reservation::calendar::one_month_display -room_id $room_id \
                         -date $date \
                         -prev_nav_template "<a href=\"?view=month&date=\$ansi_date&room_id=$room_id\">&lt;</a>" \
                         -next_nav_template "<a href=\"?view=month&date=\$ansi_date&room_id=$room_id\">&gt;</a>" \
                         -item_template "<font size=-2>$item_template</font>" \
                         -day_template "<font size=-1><b><a href=?julian_date=\$julian_date&view=day&room_id=$room_id>\$day_number</a></b></font>" \
			 -item_add_template "<font size=-3>$item_add_template</font>" \
                    ]
    }
    default {
	set content [room-reservation::calendar::one_day_display -room_id $room_id \
                         -date $date \
                         -prev_nav_template "<a href=\"?view=day&date=\[ns_urlencode \$yesterday]&room_id=$room_id\">&lt;</a>" \
                         -next_nav_template "<a href=\"?view=day&date=\[ns_urlencode \$tomorrow]&room_id=$room_id\">&gt;</a>" \
                         -item_template $item_template \
                    ]
    }
}

set calendar_navigation [dt_widget_calendar_navigation "room-reservations" $view $date "room_id=$room_id"]

ad_return_template
