# /packages/room-reservation/www/reservation-view.tcl

ad_page_contract {
    
    Shows information about a Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservation-view.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    reservation_id:integer,notnull
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_maybe_redirect_for_registration]

# Check if user has write permission for this room
set owner_p [room-reservation::reservations::owner_p -reservation_id $reservation_id -user_id $user_id]
set write_p [permission::permission_p -party_id $user_id -object_id $reservation_id -privilege "write"]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set room_id [room-reservation::reservations::get_room_id -reservation_id $reservation_id]
set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id]

set title "Reservation Info"
set context [list [list "rooms" $rooms_pretty_plural] [list "room-view?room_id=$room_id" "$room_full_name Info"] [list "room-reservations?room_id=$room_id" "$room_full_name Reservations"] $title]

room-reservation::reservations::get -reservation_id $reservation_id -array reservation_info
if {[room-reservation::reservations::check_conflict_p -reservation_id $reservation_id -room_id $reservation_info(room_id) -start_date $reservation_info(start_date) -end_date $reservation_info(end_date)]} {
    set conflict_p 1
} else {
    set conflict_p 0
}

ad_return_template
