# /packages/room-reservation/www/reservation-new.tcl

ad_page_contract {
    
    Create a new Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservation-new.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    room_id:integer,notnull
    {date ""}
    {julian_date ""}
    {start_time ""}
    {end_time ""}
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_maybe_redirect_for_registration]

room-reservation::get_ui_params -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id] 

set title "Reserve A $rooms_pretty_name"
set context [list [list "rooms" $rooms_pretty_plural] [list "room-view?room_id=$room_id" "$room_full_name Info"] [list "room-reservations?room_id=$room_id" "$room_full_name Reservations"] $title]

# let's make sure we have a date and a time
set date [calendar::adjust_date -date $date -julian_date $julian_date]
if {[empty_string_p $start_time]} {
    set start_time "10"
}
if {[empty_string_p $end_time]} {
    set end_time "11"
}
set start_time_date [calendar::from_sql_datetime -sql_date $start_time -format {HH24}]
set end_time_date [calendar::from_sql_datetime -sql_date $end_time -format {HH24}]

form create reservation

element create reservation room_id \
    -label "Room ID" \
    -datatype integer \
    -widget hidden

element create reservation room_name \
    -label "Room Name" \
    -datatype text \
    -widget inform

element create reservation name \
    -label "Event Name" \
    -datatype text \
    -widget text

element create reservation date \
    -label "Date" \
    -datatype date \
    -widget date

element create reservation start_time \
    -label "Start Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM"


element create reservation end_time \
    -label "End Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM"

element create reservation attendees \
    -label "Expected No. of Attendees" \
    -datatype integer \
    -widget text

element create reservation note \
    -label "Added Instructions / Extra Notes" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

element create reservation contact_person \
    -label "Contact Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional

element create reservation contact_email \
    -label "Contact Email" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional

element create reservation contact_phone \
    -label "Contact Phone" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional


set form_valid 0
set form_submit 1


if {[form is_valid reservation] || [form is_submission reservation]} {
    template::form get_values reservation \
        room_id name date start_time end_time attendees note contact_person contact_email contact_phone
}

if {[form is_valid reservation]} {
    set form_valid 1
}

if {$form_valid && [form is_submission reservation]} {
    set start_date [calendar::to_sql_datetime -date $date -time $start_time]
    set end_date [calendar::to_sql_datetime -date $date -time $end_time]

    if {![room-reservation::datetime::check_valid_end_date_p -date $end_date]} {
	element set_error reservation date "End date and time has already passed"
	set form_submit 0
    }

    if {![room-reservation::datetime::check_valid_dates_p -start_date $start_date -end_date $end_date]} {
	element set_error reservation date "Start date must be before end date"
	set form_submit 0
    }

    if {![room-reservation::datetime::check_valid_year_p -start_date $start_date]} {
	element set_error reservation date "Start date must fall within [parameter::get -parameter FutureYears -default 5] years from now"
	set form_submit 0
    }
    
    if {[room-reservation::reservations::check_conflict_p -room_id $room_id -start_date $start_date -end_date $end_date]} {
	set error_string "The reservation you are trying to make conflicts with reservation(s):<br>"
	set conflict_list [room-reservation::reservations::get_conflict_ids -room_id $room_id -start_date $start_date -end_date $end_date]
	foreach reservation_id $conflict_list {
	    append error_string "Reservation $reservation_id <a href=\"reservation-view?reservation_id=$reservation_id\">(view)</a><br>"
	}
	element set_error reservation date $error_string
	set form_submit 0
    }
       
    if {![empty_string_p $contact_email] && ![util_email_valid_p $contact_email]} {
	element set_error reservation contact_email "Invalid email address format for &quot;contact email"
	set form_submit 0
    }    
}

if {$form_valid && $form_submit} {
    set reservation_id [room-reservation::reservations::new -room_id $room_id \
        -name $name \
	-start_date $start_date \
	-end_date $end_date \
        -attendees $attendees \
        -note $note \
        -contact_person $contact_person \
        -contact_email $contact_email \
        -contact_phone $contact_phone \
    ]
    
    ad_returnredirect "room-reservations?room_id=$room_id"
    ad_script_abort
}

element set_properties reservation room_name -value $room_full_name

if { [form is_request reservation] } {
    element set_properties reservation room_id -value $room_id
    element set_properties reservation date -value [calendar::from_sql_datetime -sql_date $date -format "YYYY-MM-DD"]
    element set_properties reservation start_time -value $start_time_date
    element set_properties reservation end_time -value $end_time_date

}

ad_return_template
