# /packages/room-reservation/www/reservation-edit.tcl

ad_page_contract {
    
    Edit an existing Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservation-edit.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    reservation_id:integer,notnull
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_maybe_redirect_for_registration]

# Check if user has permission to edit this room
if {![room-reservation::reservations::owner_p -reservation_id $reservation_id -user_id $user_id]} {
    permission::require_permission -party_id $user_id -object_id $reservation_id -privilege "write"
}

if {![string equal "pending" [room-reservation::reservations::get_status -reservation_id $reservation_id]] && ![permission::permission_p -party_id $user_id -object_id $reservation_id -privilege "admin"]} {
    ad_return_complaint 1 "<li>you can only edit a pending reservation</li>"
}

room-reservation::get_ui_params -rooms_pretty_plural rooms_pretty_plural

set room_id [room-reservation::reservations::get_room_id -reservation_id $reservation_id]
set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id]

set title "Edit A Reservation"
set context [list [list "rooms" $rooms_pretty_plural] [list "room-view?room_id=$room_id" "$room_full_name Info"] [list "room-reservations?room_id=$room_id" "$room_full_name Reservations"] [list "reservation-view?reservation_id=$reservation_id" "Reservation Info"] $title]

form create reservation_edit

element create reservation_edit reservation_id \
    -label "Reservation ID" \
    -datatype integer \
    -widget hidden

element create reservation_edit room_id \
    -label "Room ID" \
    -datatype integer \
    -widget hidden

element create reservation_edit room_name \
    -label "Room Name" \
    -datatype text \
    -widget inform

element create reservation_edit name \
    -label "Event Name" \
    -datatype text \
    -widget text

element create reservation_edit date \
    -label "Date" \
    -datatype date \
    -widget date

element create reservation_edit start_time \
    -label "Start Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM"


element create reservation_edit end_time \
    -label "End Time" \
    -datatype date \
    -widget date \
    -format "HH12:MI AM"

element create reservation_edit attendees \
    -label "Expected No. of Attendees" \
    -datatype integer \
    -widget text

element create reservation_edit note \
    -label "Added Instructions / Extra Notes" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

element create reservation_edit contact_person \
    -label "Contact Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional

element create reservation_edit contact_email \
    -label "Contact Email" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional

element create reservation_edit contact_phone \
    -label "Contact Phone" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200} \
    -optional

set form_valid 0
set form_submit 1


if {[form is_valid reservation_edit] || [form is_submission reservation_edit]} {
    template::form get_values reservation_edit \
        reservation_id room_id name date start_time end_time attendees note contact_person contact_email contact_phone
}

if {[form is_valid reservation_edit]} {
    set form_valid 1
}

if {$form_valid && [form is_submission reservation_edit]} {
    set start_date [calendar::to_sql_datetime -date $date -time $start_time]
    set end_date [calendar::to_sql_datetime -date $date -time $end_time]

    if {![room-reservation::datetime::check_valid_end_date_p -date $end_date]} {
	element set_error reservation_edit date "End date and time has already passed"
	set form_submit 0
    }

    if {![room-reservation::datetime::check_valid_dates_p -start_date $start_date -end_date $end_date]} {
	element set_error reservation_edit date "Start date must be before end date"
	set form_submit 0
    }

    if {![room-reservation::datetime::check_valid_year_p -start_date $start_date]} {
	element set_error reservation_edit date "Start date must fall within [parameter::get -parameter FutureYears -default 5] years from now"
	set form_submit 0
    }
    
    if {[room-reservation::reservations::check_conflict_p -reservation_id $reservation_id -room_id $room_id -start_date $start_date -end_date $end_date]} {
	element set_error reservation_edit date "The reservation you are trying to make conflicts with another reservation"
	set form_submit 0
    }
       
    if {![empty_string_p $contact_email] && ![util_email_valid_p $contact_email]} {
	element set_error reservation_edit contact_email "Invalid email address format for &quot;contact email"
	set form_submit 0
    }    
}

if {$form_valid && $form_submit} {
    set result [room-reservation::reservations::edit -reservation_id $reservation_id \
        -name $name \
        -room_id $room_id \
	-start_date $start_date \
	-end_date $end_date \
        -attendees $attendees \
        -note $note \
        -contact_person $contact_person \
        -contact_email $contact_email \
        -contact_phone $contact_phone \
    ]
    

    ad_returnredirect "reservation-view?reservation_id=$reservation_id"
    ad_script_abort
}

element set_properties reservation_edit room_name -value $room_full_name

if { [form is_request reservation_edit] } {
    room-reservation::reservations::get -reservation_id $reservation_id -array reservation_info
    set start_time_date [calendar::from_sql_datetime -sql_date $reservation_info(start_time) -format {HH12:MIam}]
    set end_time_date [calendar::from_sql_datetime -sql_date $reservation_info(end_time) -format {HH12:MIam}]

    element set_properties reservation_edit reservation_id -value $reservation_info(reservation_id)
    element set_properties reservation_edit room_id -value $reservation_info(room_id)
    element set_properties reservation_edit name -value $reservation_info(name)
    element set_properties reservation_edit date -value [calendar::from_sql_datetime -sql_date $reservation_info(date) -format "YYYY-MM-DD"]
    element set_properties reservation_edit start_time -value $start_time_date
    element set_properties reservation_edit end_time -value $end_time_date
    element set_properties reservation_edit attendees -value $reservation_info(attendees)
    element set_properties reservation_edit note -value $reservation_info(note)
    element set_properties reservation_edit contact_person -value $reservation_info(contact_person)
    element set_properties reservation_edit contact_email -value $reservation_info(contact_email)
    element set_properties reservation_edit contact_phone -value $reservation_info(contact_phone)
}

ad_return_template
