# /packages/room-reservation/www/reservation-cancel.tcl

ad_page_contract {

    Room Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservation-cancel.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    reservation_id:integer,notnull
}

set user_id [ad_maybe_redirect_for_registration]

# Check if user has permission to cancel this room
if {![room-reservation::reservations::owner_p -reservation_id $reservation_id -user_id $user_id]} {
    permission::require_permission -party_id $user_id -object_id $reservation_id -privilege "write"
}

room-reservation::reservations::cancel -reservation_id $reservation_id

ad_returnredirect "rooms"

ad_return_template
