# /packages/room-reservation/www/index.tcl

ad_page_contract {

    Room Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: index.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    {filter_on ""}
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_maybe_redirect_for_registration]

set package_id [ad_conn package_id]

set admin_p [ad_permission_p $package_id admin]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set title "Room Reservation"

switch -exact -- $filter_on {
    {canceled} {
	set status "canceled"
    }
    {pending} {
	set status "pending"
    }
    {approved} {
	set status "approved"
    }
    {rejected} {
	set status "rejected"
    }
    default {
	set status ""
	set filter_on "all"
    }
}

set filter_list [list all pending approved rejected canceled]

set reservations [room-reservation::rooms::get_reservations_list_of_ns_sets \
                      -reserving_user $user_id \
                      -status_list [list $status] \
		      -package_id $package_id \
		 ]

template::util::list_of_ns_sets_to_multirow -rows $reservations -var_name personal_reservations


ad_return_template
