# /packages/room-reservation/www/admin/room-history.tcl

ad_page_contract {
    
    Shows the reservation history of a Room

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-history.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    room_id:integer,notnull
    {return_url "rooms"}
} -properties {
    title:onevalue
    context:onevalue
}

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -facilities_pretty_plural facilities_pretty_plural -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set facility_id [room-reservation::rooms::get_facility_id -room_id $room_id]
set facility_name [room-reservation::facilities::get_name -facility_id $facility_id]
set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id] 

set title "Reservation History"
set context [list [list "facilities" $facilities_pretty_plural] [list "facility-view?facility_id=$facility_id" "$facility_name $rooms_pretty_plural"] [list "room-view?room_id=$room_id" "$room_full_name Info"] $title]

db_multirow all_reservations get_room_history {}

set return_url_2 [ad_urlencode "room-view?room_id=$room_id&return_url=$return_url"]
ad_return_template
