# /packages/room-reservation/www/admin/facility-disable.tcl

ad_page_contract {
    
    Disables a Facility

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: facility-disable.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    facility_id:integer,notnull
    {return_url "facilities"}
} -properties {
    title:onevalue
    context:onevalue
}

set room_list [room-reservation::facilities::get_room_list -facility_id $facility_id]
set reservations [list]

foreach room_id $room_list {
    set one_room_reservation [room-reservation::rooms::get_reservations_list_of_ns_sets \
				  -room_id $room_id \
				  -status_list [list pending approved] \
				 ]

    set reservations [concat $reservations $one_room_reservation]
}

# are there valid reesrvations that will conflict when we disable this room?
if {[llength $reservations]} {
    room-reservation::get_ui_params -rooms_pretty_name rooms_pretty_name
    set facility_name [room-reservation::facilities::get_name -facility_id $facility_id]

    room-reservation::get_ui_params -facilities_pretty_plural facilities_pretty_plural

    set title "Disable $facility_name"
    set context [list [list "facilities" $facilities_pretty_plural] $title]

    template::util::list_of_ns_sets_to_multirow -rows $reservations -var_name reservations_list
    ad_return_template
} else {
    # no conflicts. let's proceed with disabling
    room-reservation::facilities::disable -facility_id $facility_id
    ad_returnredirect "facilities"
}
