# /packages/room-reservation/www/admin/room-new.tcl

ad_page_contract {
    
    Create a new Room

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-new.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    facility_id:integer,notnull
    {return_url "rooms"}
} -properties {
    title:onevalue
    context:onevalue
}

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -facilities_pretty_plural facilities_pretty_plural -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set facility_name [room-reservation::facilities::get_name -facility_id $facility_id]

set title "Create New $rooms_pretty_name"
set context [list [list "facilities" $facilities_pretty_plural] [list "facility-view?facility_id=$facility_id" "$facility_name $rooms_pretty_plural"] $title]

form create room

element create room room_id \
    -label "Room ID" \
    -datatype integer \
    -widget hidden

element create room facility_id \
    -label "Facility ID" \
    -datatype integer \
    -widget hidden

element create room return_url \
    -label "Return URL" \
    -datatype text \
    -widget hidden

element create room name \
    -label "Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200}

element create room description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

element create room capacity \
    -label "Capacity" \
    -datatype integer \
    -html {size 5} \
    -widget text 

element create room phone \
    -label "Phone" \
    -datatype text \
    -widget text \
    -html {size 20 maxlength 50} \
    -optional

element create room approval_needed_p \
    -label "Needs approval to reserve" \
    -datatype text \
    -widget select \
    -options {{Yes t} {No f}}

if {[form is_valid room] || [form is_submission room]} {
    template::form get_values room \
        room_id facility_id return_url name description capacity phone approval_needed_p

    if {[room-reservation::rooms::name_exists -name $name -facility_id $facility_id]} {
	element set_error room name "The name you provided is already being used."
    } else {
	set room_id [room-reservation::rooms::new -room_id $room_id \
			 -name $name \
			 -facility_id $facility_id \
			 -description $description \
			 -capacity $capacity \
			 -phone $phone \
			 -approval_needed_p $approval_needed_p \
			]
	
	ad_returnredirect $return_url
	ad_script_abort
    }
}

if { [form is_request room] } {
    # Pre-fetch the room_id
    set room_id [db_nextval acs_object_id_seq]
    element set_properties room room_id -value $room_id
    element set_properties room facility_id -value $facility_id
    element set_properties room return_url -value $return_url
    element set_properties room approval_needed_p -value t
}

ad_return_template
