<?xml version="1.0"?>
<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>


<fullquery name="get_room_history">
<querytext>

    select r.reservation_id,
	   r.status,
           coalesce(to_char(action_date, 'Mon DD, YYYY'), to_char(creation_date, 'Mon DD, YYYY')) as status_date,
           e.name,
           p.first_names||' '||p.last_name as username
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
           join rr_rooms fr
               on (r.room_id = fr.room_id)
           join acs_objects o
               on (r.reservation_id = o.object_id)
           join persons p
               on (coalesce(r.action_user, r.reserving_user) = p.person_id)
    where fr.room_id = :room_id
    order by coalesce(action_date, creation_date)

</querytext>
</fullquery>


</queryset>
