# /packages/room-reservation/www/admin/room-edit.tcl

ad_page_contract {
    
    Edits properties of an existing Room

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-edit.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    room_id:integer,notnull
    facility_id:integer,notnull
    {return_url "rooms"}
} -properties {
    title:onevalue
    context:onevalue
}

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -facilities_pretty_plural facilities_pretty_plural -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set facility_name [room-reservation::facilities::get_name -facility_id $facility_id]
set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id]

set title "Edit $rooms_pretty_name Properties"
set context [list [list "facilities" $facilities_pretty_plural] [list "facility-view?facility_id=$facility_id" "$facility_name $rooms_pretty_plural"] [list "room-view?room_id=$room_id" $room_full_name] $title]

form create room_edit

element create room_edit room_id \
    -label "Room ID" \
    -datatype integer \
    -widget hidden

element create room_edit facility_id \
    -label "Facility ID" \
    -datatype integer \
    -widget hidden

element create room_edit return_url \
    -label "Return URL" \
    -datatype text \
    -widget hidden

element create room_edit name \
    -label "Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200}

element create room_edit description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

element create room_edit capacity \
    -label "Capacity" \
    -datatype integer \
    -html {size 5} \
    -widget text 

element create room_edit phone \
    -label "Phone" \
    -datatype text \
    -widget text \
    -html {size 20 maxlength 50} \
    -optional

element create room_edit approval_needed_p \
    -label "Needs approval to reserve" \
    -datatype text \
    -widget select \
    -options {{Yes t} {No f}}

if {[form is_valid room_edit] || [form is_submission room_edit]} {
    template::form get_values room_edit \
        room_id facility_id return_url name description capacity phone approval_needed_p

    set name_exists_p [room-reservation::rooms::name_exists -name $name -facility_id $facility_id]
    if {$name_exists_p && ![string equal $name_exists_p $room_id]} {
	element set_error room_edit name "The name you provided is already being used."
    } else {
	set room_id [room-reservation::rooms::edit -room_id $room_id \
			 -name $name \
			 -facility_id $facility_id \
			 -description $description \
			 -capacity $capacity \
			 -phone $phone \
			 -approval_needed_p $approval_needed_p \
			]

	ad_returnredirect $return_url
	ad_script_abort
    }
}

if { [form is_request room_edit] } {
    # Select info for the item
    room-reservation::rooms::get -room_id $room_id -array room_info

    element set_properties room_edit room_id -value $room_id
    element set_properties room_edit return_url -value $return_url
    element set_properties room_edit name -value $room_info(name)
    element set_properties room_edit facility_id -value $room_info(facility_id)
    element set_properties room_edit description -value $room_info(description)
    element set_properties room_edit capacity -value $room_info(capacity)
    element set_properties room_edit phone -value $room_info(phone)
    element set_properties room_edit approval_needed_p -value $room_info(approval_needed_p)
}

ad_return_template
