# /packages/room-reservation/www/admin/room-disable.tcl

ad_page_contract {
    
    Disables a Room

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-disable.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    room_id:integer,notnull
    facility_id:integer,notnull
    {return_url "rooms"}
} -properties {
    title:onevalue
    context:onevalue
}

set reservations [room-reservation::rooms::get_reservations_list_of_ns_sets \
                      -room_id $room_id \
                      -status_list [list pending approved] \
		 ]

# are there valid reesrvations that will conflict when we disable this room?
if {[llength $reservations]} {
    room-reservation::get_ui_params -rooms_pretty_name rooms_pretty_name
    set room_full_name [room-reservation::rooms::get_full_name -room_id $room_id]

    set title "Disable $room_full_name"
    set context [list [list "room-view?room_id=$room_id" "View $rooms_pretty_name"] $title]

    template::util::list_of_ns_sets_to_multirow -rows $reservations -var_name reservations_list
    ad_return_template
} else {
    # no conflicts. let's proceed with disabling
    room-reservation::rooms::disable -room_id $room_id -facility_id $facility_id
    ad_returnredirect $return_url
}
