# /packages/room-reservation/www/admin/reservations.tcl

ad_page_contract {

    Room Reservation

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservations.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    {filter_on ""}
} -properties {
    title:onevalue
    context:onevalue
}

set user_id [ad_conn user_id]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -rooms_pretty_name rooms_pretty_name -rooms_pretty_plural rooms_pretty_plural

set title "Reservations"
set context $title

switch -exact -- $filter_on {
    {canceled} {
	set table_name "rr_reservations_cancel"
    }
    {pending} {
	set table_name "rr_reservations_pending"
    }
    {approved} {
	set table_name "rr_reservations_approve"
    }
    {rejected} {
	set table_name "rr_reservations_reject"
    }
    default {
	set table_name "rr_reservations"
	set filter_on "all"
    }
}

set filter_list [list all pending approved rejected canceled]

set package_id [ad_conn package_id]

db_multirow all_reservations get_all_reservations {}

set return_url "[ad_urlencode [ad_conn url]]"

ad_return_template
