<?xml version="1.0"?>
<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>


<fullquery name="get_all_reservations">
<querytext>

    select r.reservation_id,
           f.name as facility_name,
           fr.name as room_name,
	   r.status,
           to_char(start_date, 'Mon DD, YYYY HH12:MI AM') as full_start_date,
           to_char(end_date, 'Mon DD, YYYY HH12:MI AM') as full_end_date,
           (CASE
              WHEN
                r.status = 'pending'
              THEN 1
              WHEN
                r.status = 'approved'
              THEN 2
              WHEN
                r.status = 'rejected'
              THEN 3
              ELSE 4
            END) as status_order,
           e.name,
           p.first_names||' '||p.last_name as username
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join $table_name r
               on (e.event_id = r.reservation_id)
           join rr_rooms fr
               on (r.room_id = fr.room_id)
           join rr_facilities f
               on (f.facility_id = fr.facility_id)
           join persons p
               on (r.reserving_user = p.person_id)
    where f.package_id = :package_id
    order by status_order, full_start_date
</querytext>
</fullquery>


</queryset>
