# /packages/room-reservation/www/admin/facility-new.tcl

ad_page_contract {
    
    Create a new Facility

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: facility-new.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} -properties {
    title:onevalue
    context:onevalue
}

set package_id [ad_conn package_id]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -facilities_pretty_plural facilities_pretty_plural

set title "Create New $facilities_pretty_name"
set context [list [list "facilities" $facilities_pretty_plural] $title]

form create facility

element create facility facility_id \
    -label "Facility ID" \
    -datatype integer \
    -widget hidden

element create facility name \
    -label "Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200}

element create facility description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

if {[form is_valid facility] || [form is_submission facility]} {
    template::form get_values facility \
        facility_id name description 

    if {[room-reservation::facilities::name_exists -name $name]} {
	element set_error facility name "The name you provided is already being used"
    } else {
	set facility_id [room-reservation::facilities::new -facility_id $facility_id \
			     -name $name \
			     -description $description \
			     -package_id $package_id \
			]

	ad_returnredirect "facilities"
	ad_script_abort
    }
}

if { [form is_request facility] } {
    # Pre-fetch the facility_id
    set facility_id [db_nextval acs_object_id_seq]
    element set_properties facility facility_id -value $facility_id
}

ad_return_template
