# /packages/room-reservation/www/admin/facility-edit.tcl

ad_page_contract {
    
    Edits properties of an existing Facility

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: facility-edit.tcl,v 1.1 2004/03/15 03:39:31 carolinem Exp $

} {
    facility_id:integer,notnull
} -properties {
    title:onevalue
    context:onevalue
}

set package_id [ad_conn package_id]

room-reservation::get_ui_params -facilities_pretty_name facilities_pretty_name -facilities_pretty_plural facilities_pretty_plural

set title "Edit A $facilities_pretty_name"
set context [list [list "facilities" $facilities_pretty_plural] $title]

form create facility_edit

element create facility_edit facility_id \
    -label "Facility ID" \
    -datatype integer \
    -widget hidden

element create facility_edit name \
    -label "Name" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 200}

element create facility_edit description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

if {[form is_valid facility_edit] || [form is_submission facility_edit]} {
    template::form get_values facility_edit \
        facility_id name description

    set name_exists_p [room-reservation::facilities::name_exists -name $name]

    if {$name_exists_p && ![string equal $name_exists_p $facility_id]} {
	element set_error facility_edit name "The name you provided is already being used"
    } else {
	set facility_id [room-reservation::facilities::edit -facility_id $facility_id \
			     -name $name \
			     -description $description \
			     -package_id $package_id \
			]
	
	ad_returnredirect "facilities"
	ad_script_abort
    }
    
}

if { [form is_request facility_edit] } {
    # Select info for the item
    room-reservation::facilities::get -facility_id $facility_id -array facility_info

    element set_properties facility_edit facility_id -value $facility_id
    element set_properties facility_edit name -value $facility_info(name)
    element set_properties facility_edit description -value $facility_info(description)
}

ad_return_template
